/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class WeakKeyIntValueHashMap<K>
implements ObjectIntMap<K> {
    private final TObjectIntHashMap<MyReference<K>> myMap = new TObjectIntHashMap();
    private final ReferenceQueue<K> myQueue = new ReferenceQueue();
    private static final Object GCED = ObjectUtils.sentinel("GCED");

    WeakKeyIntValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            this.myMap.remove((Object)ref);
        }
        return;
    }

    @Override
    public final int get(@NotNull K key) {
        MyReference ref = new MyReference(key, null);
        return this.myMap.get(ref);
    }

    @Override
    public final int put(@NotNull K key, int value) {
        this.processQueue();
        MyReference ref = new MyReference(key, this.myQueue);
        return this.myMap.put(ref, value);
    }

    @Override
    public final int remove(@NotNull K key) {
        this.processQueue();
        MyReference ref = new MyReference(key, this.myQueue);
        return this.myMap.remove(ref);
    }

    @Override
    public final void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public final int size() {
        return this.myMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public final boolean containsKey(@NotNull K key) {
        MyReference ref = new MyReference(key, null);
        return this.myMap.containsKey(ref);
    }

    @Override
    public final int @NotNull [] values() {
        throw new IncorrectOperationException("values() makes no sense for weak/soft key map because GC can clear the key any moment now");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new THashSet(ContainerUtil.map(this.myMap.keys(), ref -> SoftReference.dereference((MyReference)ref)));
    }

    @Override
    public boolean containsValue(int value) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Iterable<ObjectIntMap.Entry<K>> entries() {
        return new Iterable<ObjectIntMap.Entry<K>>(){

            @Override
            @NotNull
            public Iterator<ObjectIntMap.Entry<K>> iterator() {
                final TObjectIntIterator tIterator = WeakKeyIntValueHashMap.this.myMap.iterator();
                return ContainerUtil.filterIterator(new Iterator<ObjectIntMap.Entry<K>>(){

                    @Override
                    public boolean hasNext() {
                        return tIterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ObjectIntMap.Entry<K> next() {
                        tIterator.advance();
                        return new ObjectIntMap.Entry<K>(){

                            @Override
                            @NotNull
                            public K getKey() {
                                Object v = SoftReference.dereference((Reference)tIterator.key());
                                return ObjectUtils.notNull(v, GCED);
                            }

                            @Override
                            public int getValue() {
                                return tIterator.value();
                            }
                        };
                    }
                }, o -> o.getKey() != GCED);
            }
        };
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int myHashCode;

        private MyReference(@NotNull T key, ReferenceQueue<? super T> q) {
            super(key, q);
            this.myHashCode = key.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyReference)) {
                return false;
            }
            MyReference other = (MyReference)obj;
            Object myKey = this.get();
            Object otherKey = other.get();
            return obj == this || myKey != null && otherKey != null && myKey.equals(otherKey);
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

