/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UnmodifiableTHashMap<K, V>
extends THashMap<K, V> {
    public UnmodifiableTHashMap(@NotNull TObjectHashingStrategy<K> strategy, @NotNull K k, V v) {
        super(strategy);
        super.put(k, v);
    }

    public UnmodifiableTHashMap(@NotNull TObjectHashingStrategy<K> strategy, @NotNull Map<? extends K, ? extends V> map) {
        super(map.size(), strategy);
        for (Map.Entry<K, V> e : map.entrySet()) {
            super.put(e.getKey(), e.getValue());
        }
    }

    public UnmodifiableTHashMap(@NotNull TObjectHashingStrategy<K> strategy, @NotNull Map<? extends K, ? extends V> map, @NotNull K additionalKey, V additionalValue) {
        this(strategy, map);
        super.put(additionalKey, additionalValue);
    }

    public V put(@NotNull K key, V value) {
        throw new UnsupportedOperationException();
    }

    public boolean retainEntries(TObjectObjectProcedure<K, V> procedure) {
        throw new UnsupportedOperationException();
    }

    public void transformValues(TObjectFunction<V, V> function) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    protected void removeAt(int index) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Collection<V> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @NotNull
    public Set<K> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }
}

