/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefKeyRefValueHashMap<K, V>
implements Map<K, V> {
    private final RefHashMap<K, ValueReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    RefKeyRefValueHashMap(@NotNull RefHashMap<K, ValueReference<K, V>> weakKeyMap) {
        this.myMap = weakKeyMap;
    }

    protected V dereference(ValueReference<K, ? extends V> reference) {
        return reference == null ? null : (V)reference.get();
    }

    @NotNull
    protected abstract ValueReference<K, V> createValueReference(@NotNull RefHashMap.Key<K> var1, V var2, ReferenceQueue<? super V> var3);

    boolean processQueue() {
        ValueReference ref;
        boolean processed = this.myMap.processQueue();
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            RefHashMap.Key weakKey = ref.getKey();
            this.myMap.removeKey(weakKey);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference<K, V> ref = this.myMap.get(key);
        return this.dereference(ref);
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        RefHashMap.Key<K> weakKey = this.myMap.createKey(key);
        ValueReference<K, V> reference = this.createValueReference(weakKey, value, this.myQueue);
        ValueReference<K, V> oldRef = this.myMap.putKey(weakKey, reference);
        return this.dereference(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.remove(key);
        return this.dereference(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    protected static interface ValueReference<K, V> {
        @NotNull
        public RefHashMap.Key<K> getKey();

        public V get();
    }
}

