/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final MyMap myMap;
    private final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private final HardKey myHardKeyInstance = new HardKey();
    @NotNull
    private final TObjectHashingStrategy<? super K> myStrategy;
    private Set<Map.Entry<K, V>> entrySet;
    private boolean processingQueue;

    RefHashMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<? super K> strategy) {
        this.myStrategy = strategy;
        this.myMap = new MyMap(initialCapacity, loadFactor);
    }

    RefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ContainerUtil.canonicalStrategy());
    }

    RefHashMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    RefHashMap() {
        this(4);
    }

    RefHashMap(@NotNull Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    RefHashMap(@NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        this(4, 0.8f, hashingStrategy);
    }

    static <K> boolean keyEqual(K k1, K k2, TObjectHashingStrategy<? super K> strategy) {
        return k1 == k2 || strategy.equals(k1, k2);
    }

    @NotNull
    protected abstract <T> Key<T> createKey(@NotNull T var1, @NotNull TObjectHashingStrategy<? super T> var2, @NotNull ReferenceQueue<? super T> var3);

    boolean processQueue() {
        boolean processed = false;
        try {
            Key wk;
            this.processingQueue = true;
            while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
                this.removeKey(wk);
                processed = true;
            }
        }
        finally {
            this.processingQueue = false;
        }
        this.myMap.compactIfNecessary();
        return processed;
    }

    V removeKey(@NotNull Key<K> key) {
        return (V)this.myMap.remove(key);
    }

    @NotNull
    Key<K> createKey(@NotNull K key) {
        return this.createKey(key, this.myStrategy, this.myReferenceQueue);
    }

    V putKey(@NotNull Key<K> weakKey, V value) {
        return (V)this.myMap.put(weakKey, value);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        this.myHardKeyInstance.set(key);
        try {
            boolean bl = this.myMap.containsKey(this.myHardKeyInstance);
            return bl;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        this.myHardKeyInstance.set(key);
        try {
            Object object = this.myMap.get(this.myHardKeyInstance);
            return (V)object;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public V put(@NotNull K key, V value) {
        this.processQueue();
        return this.putKey(this.createKey(key), value);
    }

    @Override
    public V remove(@NotNull Object key) {
        this.processQueue();
        this.myHardKeyInstance.set(key);
        try {
            Object object = this.myMap.remove(this.myHardKeyInstance);
            return (V)object;
        }
        finally {
            this.myHardKeyInstance.clear();
        }
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        return es;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<Key<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = RefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<Key<K>, V>> hashIterator;
                private MyEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = wk.get();
                        if (k == null) continue;
                        this.next = new MyEntry(ent, k, wk.hashCode(), RefHashMap.this.myStrategy);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    MyEntry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            RefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = RefHashMap.this.myHardKeyInstance;
            try {
                key.set(e.getKey());
                Object hv = RefHashMap.this.myMap.get(key);
                boolean bl = hv == null ? ev == null && RefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
                if (toRemove) {
                    RefHashMap.this.myMap.remove(key);
                }
            }
            finally {
                key.clear();
            }
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Key wk = entry.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = entry.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class MyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;
        private final int myKeyHashCode;
        @NotNull
        private final TObjectHashingStrategy<? super K> myStrategy;

        private MyEntry(@NotNull Map.Entry<?, V> ent, @NotNull K key, int keyHashCode, @NotNull TObjectHashingStrategy<? super K> strategy) {
            this.ent = ent;
            this.key = key;
            this.myKeyHashCode = keyHashCode;
            this.myStrategy = strategy;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RefHashMap.keyEqual(this.key, e.getKey(), this.myStrategy) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return this.myKeyHashCode ^ (v == null ? 0 : v.hashCode());
        }
    }

    private class HardKey
    implements Key<K> {
        private K myObject;
        private int myHash;

        private HardKey() {
        }

        @Override
        public K get() {
            return this.myObject;
        }

        private void set(@NotNull K object) {
            this.myObject = object;
            this.myHash = RefHashMap.this.myStrategy.computeHashCode(object);
        }

        private void clear() {
            this.myObject = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.myObject;
            Object u = ((Key)o).get();
            return RefHashMap.keyEqual(t, u, RefHashMap.this.myStrategy);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    @FunctionalInterface
    static interface Key<T> {
        public T get();
    }

    private final class MyMap
    extends THashMap<Key<K>, V> {
        private MyMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, new TObjectHashingStrategy<Key<K>>(){

                public int computeHashCode(Key<K> key) {
                    return key.hashCode();
                }

                public boolean equals(Key<K> o1, Key<K> o2) {
                    return o1 == o2 || RefHashMap.keyEqual(o1.get(), o2.get(), RefHashMap.this.myStrategy);
                }
            });
        }

        public void compact() {
            if (!RefHashMap.this.processingQueue) {
                super.compact();
            }
        }

        private void compactIfNecessary() {
            if (this._deadkeys > this._size && this.capacity() > 42) {
                this.compact();
            }
        }

        protected void rehash(int newCapacity) {
            int oldCapacity = this._set.length;
            Object[] oldKeys = this._set;
            Object[] oldVals = this._values;
            this._set = new Object[newCapacity];
            this._values = new Object[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                Key k;
                Object key;
                Object o = oldKeys[i];
                if (o == null || o == REMOVED || (key = (k = (Key)o).get()) == null) continue;
                int index = this.insertionIndex(k);
                if (index < 0) {
                    this.throwObjectContractViolation(this._set[-index - 1], o);
                    if (key == this._set) {
                        throw new AssertionError();
                    }
                }
                this._set[index] = o;
                this._values[index] = oldVals[i];
            }
        }
    }
}

