/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public T removeLast() {
        if (this.myLast == 0) {
            this.isWrapped = !this.isWrapped;
            this.myLast = this.myArray.length;
        }
        --this.myLast;
        T result = this.getRaw(this.myLast);
        this.myArray[this.myLast] = null;
        return result;
    }

    private T getRaw(int last) {
        return (T)this.myArray[last];
    }

    public T peekLast() {
        int last = this.myLast;
        if (last == 0) {
            last = this.myArray.length;
        }
        return this.getRaw(last - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    @NotNull
    public List<T> toList() {
        return Arrays.asList(this.normalize(this.size()));
    }

    public Object @NotNull [] toArray() {
        return this.normalize(this.size());
    }

    public T @NotNull [] toArray(T[] array) {
        if (array.length < this.size()) {
            array = ArrayUtil.newArray(ArrayUtil.getComponentType(array), this.size());
        }
        return this.normalize(array);
    }

    public T pullFirst() {
        T result = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        return this.getRaw(this.myFirst);
    }

    private int copyFromTo(int first, int last, Object[] result, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result, destinationPos, length);
        return length;
    }

    private T @NotNull [] normalize(int capacity) {
        Object[] result = new Object[capacity];
        return this.normalize(result);
    }

    private T @NotNull [] normalize(T[] result) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result, 0);
            this.copyFromTo(0, this.myLast, result, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result, 0);
        }
        return result;
    }

    public void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    public T set(int index, T value) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        T old = this.getRaw(arrayIndex);
        this.myArray[arrayIndex] = value;
        return old;
    }

    public T get(int index) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        return this.getRaw(arrayIndex);
    }

    public boolean process(@NotNull Processor<? super T> processor) {
        if (this.isWrapped) {
            T t;
            int i;
            for (i = this.myFirst; i < this.myArray.length; ++i) {
                t = this.getRaw(i);
                if (processor.process(t)) continue;
                return false;
            }
            for (i = 0; i < this.myLast; ++i) {
                t = this.getRaw(i);
                if (processor.process(t)) continue;
                return false;
            }
        } else {
            for (int i = this.myFirst; i < this.myLast; ++i) {
                T t = this.getRaw(i);
                if (processor.process(t)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start, int end) {
        if (start == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start, end);
    }
}

