/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenTHashSet<T>
extends THashSet<T> {
    public OpenTHashSet() {
    }

    public OpenTHashSet(@NotNull TObjectHashingStrategy<T> strategy) {
        super(strategy);
    }

    public OpenTHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public OpenTHashSet(int initialCapacity, @NotNull TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, strategy);
    }

    public OpenTHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public OpenTHashSet(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<T> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public OpenTHashSet(@NotNull Collection<? extends T> ts) {
        super(ts);
    }

    public OpenTHashSet(@NotNull Collection<? extends T> ts, @NotNull TObjectHashingStrategy<T> strategy) {
        super(ts, strategy);
    }

    public OpenTHashSet(@NotNull TObjectHashingStrategy<T> strategy, T ... ts) {
        super(Arrays.asList(ts), strategy);
    }

    public int index(T obj) {
        return super.index(obj);
    }

    public T get(int index) {
        return (T)this._set[index];
    }

    @Nullable
    public T get(T obj) {
        int index = this.index(obj);
        return (T)(index < 0 ? null : (Object)this.get((T)index));
    }

    @Contract(value="!null -> !null")
    public T getOrAdd(T obj) {
        boolean alreadyStored;
        int index = this.insertionIndex(obj);
        boolean bl = alreadyStored = index < 0;
        if (alreadyStored) {
            return this.get((T)(-index - 1));
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return obj;
    }
}

