/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContainerUtilRt {
    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(new LinkedList(), elements);
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> fail", pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Collection<? extends T> elements) {
        throw new AbstractMethodError("Use 'new LinkedList<>(elements)' instead");
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(new ArrayList(), elements);
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> fail", pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Collection<? extends T> elements) {
        throw new AbstractMethodError("Use 'new ArrayList<>(elements)' instead");
    }

    @NotNull
    static <T, C extends Collection<? super T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        for (T element : elements) {
            collection.add(element);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        Iterator<T> iterator = elements.iterator();
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @Deprecated
    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (element != null) {
            result.add(element);
        }
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    private static final class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList<?> INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a.length != 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return EmptyIterator.getInstance();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return EmptyListIterator.getInstance();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        @Contract(pure=true)
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Contract(pure=true)
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }
}

