/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Getter;
import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue = new ReferenceQueue();
    final ReferenceQueue<V> myValueQueue = new ReferenceQueue();
    @NotNull
    final TObjectHashingStrategy<? super K> myHashingStrategy;
    private static final ThreadLocal<HardKey<?, ?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        this.myHashingStrategy = hashingStrategy;
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        WeakKey keyReference = new WeakKey(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        ObjectUtils.reachabilityFence(k);
        return keyReference;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
        return new SoftValue(value, queue);
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.processQueues();
        this.myMap.clear();
    }

    @NotNull
    private HardKey<K, V> createHardKey(Object o) {
        Object key = o;
        HardKey<?, ?> hardKey = HARD_KEY.get();
        ((HardKey)hardKey).set(key, this.myHashingStrategy.computeHashCode(key));
        return hardKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            Object t = SoftReference.deref(valueReference);
            return (V)t;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
            Object t = SoftReference.deref(valueReference);
            return (V)t;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        return (V)SoftReference.deref(prevValReference);
    }

    private boolean processQueues() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        return removed;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (ValueReference valueReference : this.myMap.values()) {
            Object v = SoftReference.deref(valueReference);
            if (v == null) continue;
            values.add(v);
        }
        return values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        this.processQueues();
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            Object v = SoftReference.deref(valueReference);
            boolean bl = value.equals(v) && this.myMap.remove(hardKey, valueReference);
            return bl;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldVal;
        block2: {
            ValueReference<K, V> oldRef;
            KeyReference<K, V> keyRef = this.createKeyReference(key, value);
            ValueReference<K, V> newRef = keyRef.getValueReference();
            do {
                this.processQueues();
                oldRef = this.myMap.putIfAbsent(keyRef, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block2;
            } while (!this.myMap.replace(keyRef, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        this.processQueues();
        KeyReference<K, V> oldKeyReference = this.createKeyReference(key, oldValue);
        ValueReference<K, V> oldValueReference = oldKeyReference.getValueReference();
        KeyReference<K, V> newKeyReference = this.createKeyReference(key, newValue);
        ValueReference<K, V> newValueReference = newKeyReference.getValueReference();
        return this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        this.processQueues();
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> result = this.myMap.replace(keyReference, valueReference);
        return (V)SoftReference.deref(result);
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void set(@NotNull K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        private void clear() {
            this.myKey = null;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }
    }

    static class SoftValue<K, V>
    extends java.lang.ref.SoftReference<V>
    implements ValueReference<K, V> {
        @NotNull
        volatile KeyReference<K, V> myKeyReference;

        private SoftValue(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
            super(value, queue);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ValueReference)o).get();
            return v != null && v.equals(thatV);
        }

        @Override
        @NotNull
        public KeyReference<K, V> getKeyReference() {
            return this.myKeyReference;
        }
    }

    static class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<? super K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k, @NotNull ValueReference<K, V> valueReference, @NotNull TObjectHashingStrategy<? super K> strategy, @NotNull ReferenceQueue<? super K> queue) {
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.computeHashCode(k);
            this.myStrategy = strategy;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            return this.myValueReference;
        }
    }

    public static interface ValueReference<K, V>
    extends Getter<V> {
        @NotNull
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    public static interface KeyReference<K, V>
    extends Getter<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

