/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Enumerator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import org.jetbrains.annotations.NotNull;

public class BiDirectionalEnumerator<T>
extends Enumerator<T> {
    @NotNull
    private final TIntObjectHashMap<T> myIntToObjectMap;

    public BiDirectionalEnumerator(int expectNumber, @NotNull TObjectHashingStrategy<T> strategy) {
        super(expectNumber, strategy);
        this.myIntToObjectMap = new TIntObjectHashMap(expectNumber);
    }

    @Override
    public int enumerateImpl(T object) {
        int index = super.enumerateImpl(object);
        this.myIntToObjectMap.put(Math.max(index, -index), object);
        return index;
    }

    @Override
    public void clear() {
        super.clear();
        this.myIntToObjectMap.clear();
    }

    @NotNull
    public T getValue(int index) {
        Object value = this.myIntToObjectMap.get(index);
        if (value == null) {
            throw new RuntimeException("Can not find value by index " + index);
        }
        return (T)value;
    }

    public void forEachValue(@NotNull TObjectProcedure<T> procedure) {
        this.myIntToObjectMap.forEachValue(procedure);
    }
}

