/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionUtil {
    private FunctionUtil() {
    }

    @NotNull
    public static <T> Function<T, T> id() {
        return Functions.identity();
    }

    @NotNull
    public static <A, B> NullableFunction<A, B> nullConstant() {
        return NullableFunction.NULL;
    }

    @NotNull
    public static <T> Function<T, String> string() {
        return Functions.TO_STRING();
    }

    @NotNull
    public static <A, B> Function<A, B> constant(B b) {
        return a -> b;
    }

    @NotNull
    public static <A, B, C> NotNullFunction<A, C> composition(@NotNull NotNullFunction<? super B, ? extends C> f, @NotNull NotNullFunction<? super A, ? extends B> g) {
        return a -> f.fun((Object)g.fun((Object)a));
    }

    @Contract(value="_, null -> param1; null, !null -> param2", pure=true)
    public static Runnable composeRunnables(@Nullable Runnable r1, @Nullable Runnable r2) {
        if (r2 == null) {
            return r1;
        }
        if (r1 == null) {
            return r2;
        }
        return () -> {
            try {
                r1.run();
            }
            catch (Error | RuntimeException ex) {
                try {
                    r2.run();
                }
                catch (Error | RuntimeException ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
            r2.run();
        };
    }
}

