/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance(EventDispatcher.class);
    private T myMulticaster;
    private final DisposableWrapperList<T> myListeners = new DisposableWrapperList();
    @NotNull
    private final Class<T> myListenerClass;
    @Nullable
    private final Map<String, Object> myMethodReturnValues;

    @NotNull
    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        return new EventDispatcher<T>(listenerClass, null);
    }

    @NotNull
    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass, @NotNull Map<String, Object> methodReturnValues) {
        EventDispatcher.assertNonVoidMethodReturnValuesAreDeclared(methodReturnValues, listenerClass);
        return new EventDispatcher<T>(listenerClass, methodReturnValues);
    }

    private static void assertNonVoidMethodReturnValuesAreDeclared(@NotNull Map<String, Object> methodReturnValues, @NotNull Class<?> listenerClass) {
        ArrayList<Method> declared = new ArrayList<Method>(ReflectionUtil.getClassPublicMethods(listenerClass));
        for (Map.Entry<String, Object> entry : methodReturnValues.entrySet()) {
            String methodName = entry.getKey();
            Method found = (Method)((Object)ContainerUtil.find(declared, m -> methodName.equals(m.getName())));
            assert (found != null) : "Method " + methodName + " must be declared in " + listenerClass;
            assert (!found.getReturnType().equals(Void.TYPE)) : "Method " + methodName + " must be non-void if you want to specify what its proxy should return";
            Object returnValue = entry.getValue();
            assert (ReflectionUtil.boxType(found.getReturnType()).isAssignableFrom(returnValue.getClass())) : "You specified that method " + methodName + " proxy will return " + returnValue + " but its return type is " + found.getReturnType() + " which is incompatible with " + returnValue.getClass();
            declared.remove(found);
        }
        for (Method method : declared) {
            assert (method.getReturnType().equals(Void.TYPE)) : "Method " + method + " returns " + method.getReturnType() + " and yet you didn't specify what its proxy should return";
        }
    }

    private EventDispatcher(@NotNull Class<T> listenerClass, @Nullable Map<String, Object> methodReturnValues) {
        this.myListenerClass = listenerClass;
        this.myMethodReturnValues = methodReturnValues;
    }

    public static <T> T createMulticaster(@NotNull Class<T> listenerClass, @NotNull Getter<? extends Iterable<T>> listeners) {
        return EventDispatcher.createMulticaster(listenerClass, null, listeners);
    }

    @NotNull
    static <T> T createMulticaster(@NotNull Class<T> listenerClass, @Nullable Map<String, Object> methodReturnValues, @NotNull Getter<? extends Iterable<T>> listeners) {
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        return (T)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (proxy, method, args) -> {
            String methodName = method.getName();
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy, args, methodName);
            }
            if (methodReturnValues != null && methodReturnValues.containsKey(methodName)) {
                return methodReturnValues.get(methodName);
            }
            EventDispatcher.dispatchVoidMethod((Iterable)listeners.get(), method, args);
            return null;
        });
    }

    @Nullable
    public static Object handleObjectMethod(Object proxy, Object[] args, String methodName) {
        if (methodName.equals("toString")) {
            return "Multicaster";
        }
        if (methodName.equals("hashCode")) {
            return System.identityHashCode(proxy);
        }
        if (methodName.equals("equals")) {
            return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
        }
        LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
        return null;
    }

    @NotNull
    public T getMulticaster() {
        Object multicaster = this.myMulticaster;
        if (multicaster == null) {
            this.myMulticaster = multicaster = (EventListener)EventDispatcher.createMulticaster(this.myListenerClass, this.myMethodReturnValues, new StaticGetter<DisposableWrapperList<T>>(this.myListeners));
        }
        return multicaster;
    }

    private static <T> void dispatchVoidMethod(@NotNull Iterable<? extends T> listeners, @NotNull Method method, Object[] args) {
        List<Throwable> exceptions = null;
        method.setAccessible(true);
        for (T listener : listeners) {
            try {
                method.invoke(listener, args);
            }
            catch (Throwable e) {
                exceptions = EventDispatcher.handleException(e, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    public static List<Throwable> handleException(@NotNull Throwable e, @Nullable List<Throwable> exceptions) {
        Throwable cause;
        Throwable exception = e;
        if (e instanceof InvocationTargetException && (cause = e.getCause()) != null) {
            if (cause instanceof AbstractMethodError) {
                return exceptions;
            }
            exception = cause;
        }
        if (exceptions == null) {
            exceptions = new ArrayList<Throwable>();
        }
        exceptions.add(exception);
        return exceptions;
    }

    public static void throwExceptions(@NotNull List<Throwable> exceptions) {
        if (exceptions.size() != 1) {
            for (Throwable exception : exceptions) {
                if (!(exception instanceof ProcessCanceledException)) continue;
                throw (ProcessCanceledException)exception;
            }
            throw new CompoundRuntimeException(exceptions);
        }
        ExceptionUtil.rethrow(exceptions.get(0));
    }

    public void addListener(@NotNull T listener) {
        this.myListeners.add(listener);
    }

    public void addListener(@NotNull T listener, @NotNull Disposable parentDisposable) {
        this.myListeners.add(listener, parentDisposable);
    }

    public void removeListener(@NotNull T listener) {
        this.myListeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    @NotNull
    public List<T> getListeners() {
        return this.myListeners;
    }

    public void neuterMultiCasterWhilePerformanceTestIsRunningUntil(@NotNull Disposable disposable) {
        T multicaster = this.myMulticaster;
        this.myMulticaster = (EventListener)EventDispatcher.createMulticaster(this.myListenerClass, this.myMethodReturnValues, new StaticGetter(Collections.emptyList()));
        Disposer.register(disposable, () -> {
            this.myMulticaster = multicaster;
        });
    }
}

