/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Chunk<Node> {
    @NotNull
    private final Set<Node> myNodes;

    public Chunk(Node node) {
        this(Collections.singleton(node));
    }

    public Chunk(@NotNull Set<Node> nodes) {
        this.myNodes = nodes;
    }

    @NotNull
    public Set<Node> getNodes() {
        return this.myNodes;
    }

    public boolean containsNode(Node node) {
        return this.myNodes.contains(node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Chunk)) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        return this.myNodes.equals(chunk.myNodes);
    }

    public int hashCode() {
        return this.myNodes.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Node node : this.myNodes) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(node.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

