/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;

public class BuiltinWebServerAccess {
    private static final String TOKEN_FILE = "user.token";
    private static String ourUserAuthenticationToken = null;
    private static final Object LOCK = new Object();
    private static boolean ourTokenInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getUserAuthenticationToken() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (ourUserAuthenticationToken != null) {
                return ourUserAuthenticationToken;
            }
            if (ourTokenInitialized) {
                throw new IOException("User Authentication Token not found");
            }
            ourTokenInitialized = true;
            File tokenFile = BuiltinWebServerAccess.getTokenFile();
            ourUserAuthenticationToken = tokenFile.exists() ? FileUtil.loadFile(tokenFile) : BuiltinWebServerAccess.createUserAuthenticationToken();
            return ourUserAuthenticationToken;
        }
    }

    private static File getTokenFile() {
        String configPath = PathManager.getConfigPath();
        return new File(configPath + '/' + TOKEN_FILE);
    }

    private static String createUserAuthenticationToken() throws IOException {
        try {
            byte[] seed = SecureRandom.getInstance("SHA1PRNG").generateSeed(24);
            String token = new BigInteger(seed).toString(36);
            FileUtil.writeToFile(BuiltinWebServerAccess.getTokenFile(), token);
            return token;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Unable to create User Authentication Token", ex);
        }
    }
}

