/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Iconable;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DummyIconManager
implements IconManager {
    static final IconManager INSTANCE = new DummyIconManager();

    private DummyIconManager() {
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        return DummyIcon.INSTANCE;
    }

    @Override
    @NotNull
    public Icon getAnalyzeIcon() {
        return DummyIcon.INSTANCE;
    }

    @Override
    @NotNull
    public RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        return new DummyRowIcon();
    }

    @Override
    public void registerIconLayer(int flagMask, @NotNull Icon icon) {
    }

    @Override
    @NotNull
    public <T> Icon createDeferredIcon(@NotNull Icon base, T param, @NotNull Function<? super T, ? extends Icon> f) {
        return base;
    }

    @Override
    @NotNull
    public RowIcon createRowIcon(int iconCount, RowIcon.Alignment alignment) {
        return new DummyRowIcon(iconCount);
    }

    @Override
    @NotNull
    public Icon createLayered(Icon ... icons) {
        return new DummyRowIcon(icons);
    }

    @Override
    @NotNull
    public RowIcon createRowIcon(Icon ... icons) {
        return new DummyRowIcon(icons);
    }

    private static class DummyRowIcon
    extends DummyIcon
    implements RowIcon {
        private Icon[] icons;

        DummyRowIcon(int iconCount) {
            this.icons = new Icon[iconCount];
        }

        DummyRowIcon(Icon[] icons) {
            this.icons = icons;
        }

        DummyRowIcon() {
        }

        @Override
        public int getIconCount() {
            return this.icons == null ? 0 : this.icons.length;
        }

        @Override
        public Icon getIcon(int index) {
            return this.icons[index];
        }

        @Override
        public void setIcon(Icon icon, int i) {
            if (this.icons == null) {
                this.icons = new Icon[4];
            }
            this.icons[i] = icon;
        }

        @Override
        @NotNull
        public Icon getDarkIcon(boolean isDark) {
            return this;
        }

        @Override
        public Icon @NotNull [] getAllIcons() {
            return this.icons == null ? new Icon[]{} : ContainerUtil.packNullables(this.icons).toArray(new Icon[0]);
        }
    }

    private static class DummyIcon
    implements Icon {
        static final DummyIcon INSTANCE = new DummyIcon();

        private DummyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof DummyIcon;
        }
    }
}

