/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ExceptionUtilRt;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PropertyAccessor
implements MutableAccessor {
    private static final Logger LOG = Logger.getInstance(PropertyAccessor.class);
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;

    public PropertyAccessor(@NotNull String name, @NotNull Class<?> type, @NotNull Method readMethod, @Nullable Method writeMethod) {
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.myWriteMethod = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            if (this.myWriteMethod != null) {
                this.myWriteMethod.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @NotNull
    public String getGetterName() {
        return this.myReadMethod.getName();
    }

    @Override
    public Object read(@NotNull Object o) {
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            ExceptionUtilRt.rethrowUnchecked(e.getTargetException());
            throw new SerializationException(e);
        }
    }

    @Override
    public Object readUnsafe(@NotNull Object o) throws IllegalAccessException, InvocationTargetException {
        return this.myReadMethod.invoke(o, new Object[0]);
    }

    @Override
    public int readInt(@NotNull Object o) throws IllegalAccessException, InvocationTargetException {
        return (Integer)this.myReadMethod.invoke(o, new Object[0]);
    }

    @Override
    public long readLong(@NotNull Object o) throws IllegalAccessException, InvocationTargetException {
        return (Long)this.myReadMethod.invoke(o, new Object[0]);
    }

    @Override
    public float readFloat(@NotNull Object o) throws IllegalAccessException, InvocationTargetException {
        return ((Float)this.myReadMethod.invoke(o, new Object[0])).floatValue();
    }

    @Override
    public double readDouble(@NotNull Object o) throws IllegalAccessException, InvocationTargetException {
        return (Double)this.myReadMethod.invoke(o, new Object[0]);
    }

    @Override
    public boolean readBoolean(@NotNull Object o) throws IllegalAccessException, InvocationTargetException {
        return (Boolean)this.myReadMethod.invoke(o, new Object[0]);
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        if (this.myWriteMethod == null) {
            throw new SerializationException(host.getClass().getName() + "::" + this.myName + " lacks a setter");
        }
        try {
            this.myWriteMethod.invoke(host, value);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            T[] constants;
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException && this.myGenericType instanceof Class && ((Class)this.myGenericType).isEnum() && cause.getMessage().contains("Parameter specified as non-null is null:") && (constants = ((Class)this.myGenericType).getEnumConstants()).length > 0) {
                try {
                    LOG.warn("Cannot set enum value, will be set to first enum value", e);
                    this.myWriteMethod.invoke(host, constants[0]);
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e1) {
                    throw new SerializationException(e);
                }
            }
            throw new SerializationException(cause);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        this.set(host, value);
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        this.set(host, value);
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        this.set(host, value);
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        this.set(host, value);
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        this.set(host, value);
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        this.set(host, Float.valueOf(value));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        T annotation = this.myReadMethod.getAnnotation(annotationClass);
        if (annotation == null && this.myWriteMethod != null) {
            annotation = this.myWriteMethod.getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    @NotNull
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isWritable() {
        return this.myWriteMethod != null && this.myWriteMethod.isAccessible();
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor(name=" + this.myName + ", class=" + this.myReadMethod.getDeclaringClass().getName() + ")";
    }
}

