/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    private ClassUtil() {
    }

    @NotNull
    public static Class<?> typeToClass(@NotNull Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            Type bound = ((TypeVariable)type).getBounds()[0];
            return bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
        }
        if (type instanceof WildcardType) {
            return (Class)((WildcardType)type).getUpperBounds()[0];
        }
        return (Class)((ParameterizedType)type).getRawType();
    }

    public static boolean isPrimitive(@NotNull Class<?> aClass) {
        return aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass);
    }

    public static boolean isMutableCollection(@NotNull Object object) {
        if (object == Collections.emptyList() || object == Collections.emptySet()) {
            return false;
        }
        if (object instanceof Collection) {
            String simpleName = object.getClass().getSimpleName();
            return !simpleName.equals("EmptyList") && !simpleName.startsWith("Unmodifiable") && !simpleName.equals("EmptySet");
        }
        return false;
    }

    public static boolean isMutableMap(@NotNull Map object) {
        if (object == Collections.emptyMap()) {
            return false;
        }
        String simpleName = object.getClass().getSimpleName();
        return !simpleName.equals("EmptyMap") && !simpleName.equals("UnmodifiableMap");
    }

    @Nullable
    public static Object stringToEnum(@NotNull String value, @NotNull Class<? extends Enum<?>> valueClass, boolean isAlwaysIgnoreCase) {
        Enum<?>[] enumConstants = valueClass.getEnumConstants();
        if (!isAlwaysIgnoreCase) {
            for (Enum<?> enumConstant : enumConstants) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
        }
        for (Enum<?> enumConstant : enumConstants) {
            if (!enumConstant.toString().equalsIgnoreCase(value)) continue;
            return enumConstant;
        }
        return null;
    }
}

