/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.text.OrdinalFormat;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.time.Duration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Formats {
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};
    private static final String[] PADDED_FORMATS = new String[]{"%03d", "%02d", "%02d", "%02d", "%d"};

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        return StringUtilRt.formatFileSize(fileSize);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String unitSeparator) {
        return StringUtilRt.formatFileSize(fileSize, unitSeparator);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration) {
        return Formats.formatDuration(duration, " ");
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(@NotNull Duration duration) {
        return Formats.formatDuration(duration.toMillis());
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration, @NotNull String unitSeparator) {
        return Formats.formatDuration(duration, unitSeparator, Integer.MAX_VALUE);
    }

    @Contract(pure=true)
    @NotNull
    private static String formatDuration(long duration, @NotNull String unitSeparator, int maxFragments) {
        long multiplier;
        int i;
        TLongArrayList unitValues = new TLongArrayList();
        TIntArrayList unitIndices = new TIntArrayList();
        long count = duration;
        for (i = 1; i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder == 0L && unitValues.isEmpty()) continue;
            unitValues.insert(0, remainder);
            unitIndices.insert(0, i - 1);
        }
        unitValues.insert(0, count);
        unitIndices.insert(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.get(maxFragments - 1);
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.get(maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.get(maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return Formats.formatDuration(duration + increment, unitSeparator, maxFragments);
            }
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < unitValues.size() && i < maxFragments; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(unitValues.get(i)).append(unitSeparator).append(TIME_UNITS[unitIndices.get(i)]);
        }
        return result.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDurationPadded(long millis, @NotNull String unitSeparator) {
        long multiplier;
        int i;
        StringBuilder result = new StringBuilder();
        long millisIn = 1L;
        for (i = 1; i < TIME_MULTIPLIERS.length && millis >= (millisIn *= (multiplier = TIME_MULTIPLIERS[i])); ++i) {
        }
        long d = millis;
        --i;
        while (i >= 0) {
            String format;
            long multiplier2 = i == TIME_MULTIPLIERS.length - 1 ? 1L : TIME_MULTIPLIERS[i + 1];
            long value = d / (millisIn /= multiplier2);
            d %= millisIn;
            String string = format = result.length() == 0 ? "%d" : PADDED_FORMATS[i];
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(String.format(format, value)).append(unitSeparator).append(TIME_UNITS[i]);
            --i;
        }
        return result.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDurationApproximate(long duration) {
        return Formats.formatDuration(duration, " ", 2);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatOrdinal(long num) {
        return OrdinalFormat.formatEnglish(num);
    }
}

