/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.ColorHexUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<RegistryValueListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private double myDoubleCachedValue = Double.NaN;
    private Boolean myBooleanCachedValue;
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);

    RegistryValue(@NotNull Registry registry, @NonNls @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    public String getKey() {
        return this.myKey;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        return value;
    }

    public boolean asBoolean() {
        Boolean result = this.myBooleanCachedValue;
        if (result == null) {
            this.myBooleanCachedValue = result = this.calcBoolean();
        }
        return result;
    }

    @NotNull
    private Boolean calcBoolean() {
        return Boolean.valueOf(this.get(this.myKey, "false", true));
    }

    public int asInteger() {
        Integer result = this.myIntCachedValue;
        if (result == null) {
            this.myIntCachedValue = result = this.calcInt();
        }
        return result;
    }

    @NotNull
    private Integer calcInt() {
        try {
            return Integer.valueOf(this.get(this.myKey, "0", true));
        }
        catch (NumberFormatException e) {
            String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
            assert (bundleValue != null);
            return Integer.valueOf(bundleValue);
        }
    }

    public double asDouble() {
        double result = this.myDoubleCachedValue;
        if (Double.isNaN(result)) {
            this.myDoubleCachedValue = result = this.calcDouble();
        }
        return result;
    }

    private double calcDouble() {
        try {
            return Double.parseDouble(this.get(this.myKey, "0.0", true));
        }
        catch (NumberFormatException e) {
            String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
            assert (bundleValue != null);
            return Double.parseDouble(bundleValue);
        }
    }

    Color asColor(Color defaultValue) {
        String s = this.get(this.myKey, null, true);
        if (s != null) {
            Color color = ColorHexUtil.fromHex(s, null);
            if (color != null && this.myKey.contains("color")) {
                return color;
            }
            String[] rgb = s.split(",");
            if (rgb.length == 3) {
                try {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.getDescription();
        }
        return this.get(this.myKey + ".description", "", false);
    }

    boolean isRestartRequired() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.isRestartRequired();
        }
        return Boolean.parseBoolean(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString(), Registry.getInstance());
    }

    @Nullable
    public String getPluginId() {
        return this.myKeyDescriptor != null ? this.myKeyDescriptor.getPluginId() : null;
    }

    final boolean isChangedFromDefault(@NotNull String newValue, @NotNull Registry registry) {
        return !newValue.equals(registry.getBundleValue(this.myKey, false));
    }

    protected String get(@NonNls @NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    @Nullable
    private String _get(@NonNls @NotNull String key, @Nullable String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String bundleValue;
        String userValue = this.myRegistry.getUserProperties().get(key);
        if (userValue != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        if (!this.myRegistry.isLoaded()) {
            LOG.warn("The registry key '" + key + "' accessed, but not loaded yet");
        }
        return (bundleValue = Registry.getInstance().getBundleValue(key, mustExistInBundle)) == null ? defaultValue : bundleValue;
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.toString(value));
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public void setValue(String value) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault() && !this.isRestartRequired()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
        LOG.info("Registry value '" + this.myKey + "' has changed to '" + value + '\'');
    }

    public void setValue(boolean value, @NotNull Disposable parentDisposable) {
        boolean prev = this.asBoolean();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public void setValue(int value, @NotNull Disposable parentDisposable) {
        int prev = this.asInteger();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public void setValue(String value, @NotNull Disposable parentDisposable) {
        String prev = this.asString();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        this.setValue(Registry.getInstance().getBundleValue(this.myKey, true));
    }

    public void addListener(@NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register(parent, () -> this.myListeners.remove(listener));
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myDoubleCachedValue = Double.NaN;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValue.isBoolean(this.asString());
    }

    private static boolean isBoolean(String s) {
        return "true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s);
    }
}

