/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class Registry {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private final Map<String, RegistryKeyDescriptor> myContributedKeys = new HashMap<String, RegistryKeyDescriptor>();
    private static final Registry ourInstance;
    private volatile boolean myLoaded = false;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        return Registry.getInstance().doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        RegistryValue value = (RegistryValue)this.myValues.get(key);
        if (value != null) {
            return value;
        }
        value = new RegistryValue(this, key, this.myContributedKeys.get(key));
        RegistryValue prev = this.myValues.putIfAbsent(key, value);
        return prev == null ? value : prev;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            LoadingState.LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asInteger();
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue) {
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            LoadingState.LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static double doubleValue(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asString();
    }

    public static Color getColor(@NonNls @NotNull String key, Color defaultValue) throws MissingResourceException {
        return Registry.get(key).asColor(defaultValue);
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public String getBundleValue(@NonNls @NotNull String key, boolean mustExist) throws MissingResourceException {
        if (this.myContributedKeys.containsKey(key)) {
            return this.myContributedKeys.get(key).getDefaultValue();
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        return ourInstance;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        return state;
    }

    @ApiStatus.Internal
    public void loadState(@NotNull Element state) {
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = this.doGet(key)).isChangedFromDefault(value, this)) continue;
            this.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
        this.markAsLoaded();
    }

    @ApiStatus.Internal
    public void markAsLoaded() {
        this.myLoaded = true;
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, String> getUserProperties() {
        return this.myUserProperties;
    }

    @NotNull
    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        Map<String, RegistryKeyDescriptor> contributedKeys = Registry.getInstance().myContributedKeys;
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired") || contributedKeys.containsKey(each)) continue;
            result.add(Registry.get(each));
        }
        for (String key : contributedKeys.keySet()) {
            result.add(Registry.get(key));
        }
        return result;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>(this.myUserProperties);
        for (String each : old.keySet()) {
            try {
                Registry.get(each).resetToDefault();
            }
            catch (MissingResourceException e) {
                this.myValues.remove(each);
            }
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    public boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        for (String s : map.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    public static synchronized void addKeys(@NotNull List<RegistryKeyDescriptor> descriptors) {
        for (RegistryKeyDescriptor descriptor : descriptors) {
            Registry.ourInstance.myContributedKeys.put(descriptor.getName(), descriptor);
        }
    }

    public static synchronized void removeKey(@NonNls @NotNull String key) {
        Registry.ourInstance.myContributedKeys.remove(key);
        Registry.ourInstance.myValues.remove(key);
    }

    @Deprecated
    public static synchronized void addKey(@NonNls @NotNull String key, @NotNull String description, int defaultValue, boolean restartRequired) {
        Registry.getInstance().myContributedKeys.put(key, new RegistryKeyDescriptor(key, description, Integer.toString(defaultValue), restartRequired, null));
    }

    static {
        ourInstance = new Registry();
    }
}

