/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.text.StringFactory;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamUtil {
    private static final Logger LOG = Logger.getInstance(StreamUtil.class);

    private StreamUtil() {
    }

    public static int copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    public static byte @NotNull [] loadFromStream(@NotNull InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copyStreamContent(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        return outputStream.toByteArray();
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream) throws IOException {
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, StandardCharsets.UTF_8);
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, encoding);
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull Charset encoding) throws IOException {
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, encoding);
    }

    @NotNull
    public static String convertSeparators(@NotNull String s) {
        return StringFactory.createShared(StreamUtil.convertSeparators(s.toCharArray()));
    }

    public static char @NotNull [] readTextAndConvertSeparators(@NotNull Reader reader) throws IOException {
        char[] buffer = StreamUtil.readText(reader);
        return StreamUtil.convertSeparators(buffer);
    }

    private static char @NotNull [] convertSeparators(char @NotNull [] buffer) {
        int dst = 0;
        int prev = 32;
        for (int n : buffer) {
            switch (n) {
                case 13: {
                    buffer[dst++] = 10;
                    break;
                }
                case 10: {
                    if (prev == 13) break;
                    buffer[dst++] = 10;
                    break;
                }
                default: {
                    buffer[dst++] = n;
                }
            }
            prev = n;
        }
        if (dst == buffer.length) {
            return buffer;
        }
        char[] result = new char[dst];
        System.arraycopy(buffer, 0, result, 0, result.length);
        return result;
    }

    @NotNull
    public static String readTextFrom(@NotNull Reader reader) throws IOException {
        return StringFactory.createShared(StreamUtil.readText(reader));
    }

    private static char @NotNull [] readText(@NotNull Reader reader) throws IOException {
        int read;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while ((read = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, read);
        }
        return writer.toCharArray();
    }

    public static void closeStream(@Nullable Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }
}

