/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PathExecLazyValue
extends AtomicNotNullLazyValue<Boolean> {
    private final String myName;

    public PathExecLazyValue(@NotNull String name) {
        if (StringUtil.containsAnyChar(name, "/\\")) {
            throw new IllegalArgumentException(name);
        }
        this.myName = name;
    }

    @Override
    @NotNull
    protected Boolean compute() {
        String path = EnvironmentUtil.getValue("PATH");
        if (path != null) {
            for (String dir : StringUtil.tokenize(path, File.pathSeparator)) {
                if (!new File(dir, this.myName).canExecute()) continue;
                return true;
            }
        }
        return false;
    }
}

