/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectNode {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance(ObjectNode.class);
    private final ObjectTree myTree;
    private ObjectNode myParent;
    private final Disposable myObject;
    private List<ObjectNode> myChildren;
    private Throwable myTrace;

    ObjectNode(@NotNull ObjectTree tree, @Nullable ObjectNode parentNode, @NotNull Disposable object) {
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = parentNode == null && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    void addChild(@NotNull ObjectNode child) {
        List<ObjectNode> children = this.myChildren;
        if (children == null) {
            this.myChildren = new SmartList<ObjectNode>(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode child) {
        List<ObjectNode> children = this.myChildren;
        if (children != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode node = children.get(i);
                if (!node.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectNode getParent() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            return this.myParent;
        }
    }

    void execute(@NotNull List<? super Throwable> exceptions, boolean onlyChildren) {
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), each -> {
            ObjectNode[] childrenArray;
            if (this.myTree.getDisposalInfo(this.myObject) != null) {
                return;
            }
            if (!onlyChildren && this.myObject instanceof Disposable.Parent) {
                try {
                    ((Disposable.Parent)this.myObject).beforeTreeDispose();
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
            Object object = this.myTree.treeLock;
            synchronized (object) {
                List<ObjectNode> children = this.myChildren;
                childrenArray = children == null || children.isEmpty() ? EMPTY_ARRAY : children.toArray(EMPTY_ARRAY);
                this.myChildren = null;
            }
            for (int i = childrenArray.length - 1; i >= 0; --i) {
                try {
                    ObjectNode childNode = childrenArray[i];
                    childNode.execute(exceptions, false);
                    Object object2 = this.myTree.treeLock;
                    synchronized (object2) {
                        childNode.myParent = null;
                        continue;
                    }
                }
                catch (Throwable e) {
                    exceptions.add(e);
                }
            }
            if (onlyChildren) {
                return;
            }
            try {
                this.myObject.dispose();
                this.myTree.rememberDisposedTrace(this.myObject);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            this.removeFromObjectTree();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromObjectTree() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myTree.putNode(this.myObject, null);
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            }
        }
    }

    @NotNull
    Disposable getObject() {
        return this.myObject;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void clearTrace() {
        this.myTrace = null;
    }

    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        assert (this.getObject() != aDisposable);
        if (this.myChildren != null) {
            for (ObjectNode node : this.myChildren) {
                node.assertNoReferencesKept(aDisposable);
            }
        }
    }

    <D extends Disposable> D findChildEqualTo(@NotNull D object) {
        List<ObjectNode> children = this.myChildren;
        if (children != null) {
            for (ObjectNode node : children) {
                Disposable nodeObject = node.getObject();
                if (!nodeObject.equals(object)) continue;
                return (D)nodeObject;
            }
        }
        return null;
    }
}

