/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LowMemoryWatcher {
    private static final Logger LOG = Logger.getInstance(LowMemoryWatcher.class);
    private static final WeakList<LowMemoryWatcher> ourListeners = new WeakList();
    private final Runnable myRunnable;
    private final LowMemoryWatcherType myType;
    private static final AtomicBoolean ourNotificationsSuppressed = new AtomicBoolean();

    public static <T> T runWithNotificationsSuppressed(Computable<T> runnable) {
        if (ourNotificationsSuppressed.getAndSet(true)) {
            throw new IllegalStateException("runWithNotificationsSuppressed does not support reentrancy");
        }
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            ourNotificationsSuppressed.set(false);
        }
    }

    public static void onLowMemorySignalReceived(boolean afterGc) {
        LOG.info("Low memory signal received: afterGc=" + afterGc);
        for (LowMemoryWatcher watcher : ourListeners.toStrongList()) {
            try {
                if (watcher.myType != LowMemoryWatcherType.ALWAYS && (watcher.myType != LowMemoryWatcherType.ONLY_AFTER_GC || !afterGc)) continue;
                watcher.myRunnable.run();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    static boolean notificationsSuppressed() {
        return ourNotificationsSuppressed.get();
    }

    @Contract(pure=true)
    public static LowMemoryWatcher register(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType notificationType) {
        return new LowMemoryWatcher(runnable, notificationType);
    }

    @Contract(pure=true)
    public static LowMemoryWatcher register(@NotNull Runnable runnable) {
        return new LowMemoryWatcher(runnable, LowMemoryWatcherType.ALWAYS);
    }

    public static void register(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType notificationType, @NotNull Disposable parentDisposable) {
        LowMemoryWatcher watcher = new LowMemoryWatcher(runnable, notificationType);
        Disposer.register(parentDisposable, () -> watcher.stop());
    }

    public static void register(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        LowMemoryWatcher.register(runnable, LowMemoryWatcherType.ALWAYS, parentDisposable);
    }

    private LowMemoryWatcher(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType type) {
        this.myRunnable = runnable;
        this.myType = type;
        ourListeners.add(this);
    }

    public void stop() {
        ourListeners.remove(this);
    }

    static void stopAll() {
        ourListeners.clear();
    }

    public static enum LowMemoryWatcherType {
        ALWAYS,
        ONLY_AFTER_GC;

    }
}

