/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    private static final ConcurrentMap<Class, Map<String, Field>> ourFieldCache = ConcurrentFactoryMap.createMap(c -> {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Field field : c.getFields()) {
            int modifiers;
            String name = field.getName();
            if (name.indexOf(36) >= 0 || result.containsKey(name) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null) continue;
            field.setAccessible(true);
            if (field.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
            result.put(name, field);
        }
        return result;
    });

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(data, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") JDOMFilter filter) throws WriteExternalException {
        for (Field field : ((Map)ourFieldCache.get(data.getClass())).values()) {
            Element element;
            String value;
            block23: {
                if (filter != null && !filter.isAccept(field)) continue;
                Class<?> type = field.getType();
                value = null;
                try {
                    if (type.isPrimitive()) {
                        if (type.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data));
                        } else if (type.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data));
                        } else if (type.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data));
                        } else if (type.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data));
                        } else if (type.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data));
                        } else if (type.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data));
                        } else if (type.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data));
                        } else {
                            if (!type.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data));
                        }
                        break block23;
                    }
                    if (type.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block23;
                    }
                    if (type.isEnum()) {
                        value = field.get(data).toString();
                        break block23;
                    }
                    if (type.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block23;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    static String filterXMLCharacters(@Nullable String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Verifier.isXMLCharacter((int)c)) {
                if (builder == null) continue;
                builder.append(c);
                continue;
            }
            if (builder != null) continue;
            builder = new StringBuilder(value.length() + 5);
            builder.append(value, 0, i);
        }
        if (builder != null) {
            value = builder.toString();
        }
        return value;
    }

    public static void readExternal(@NotNull Object data, Element parentNode) throws InvalidDataException {
        if (parentNode == null) {
            return;
        }
        Map fields = (Map)ourFieldCache.get(data.getClass());
        block12: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Object value;
                Field field = (Field)fields.get(fieldName);
                if (field == null) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    value = field.get(data);
                    if (!(value instanceof JDOMExternalizable)) continue;
                    List children = e.getChildren("value");
                    for (Object child : children) {
                        Element valueTag = (Element)child;
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    if (value == null) continue;
                    if (type.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field.setInt(data, i);
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, ((String)value).charAt(0));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type.isEnum()) {
                    for (Object enumValue : type.getEnumConstants()) {
                        if (!enumValue.toString().equals(value)) continue;
                        field.set(data, enumValue);
                        continue block12;
                    }
                    continue;
                }
                if (type.equals(String.class)) {
                    field.set(data, value);
                    continue;
                }
                if (type.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field.set(data, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type)) {
                    List children = e.getChildren("value");
                    if (children.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element : children) {
                        object = (JDOMExternalizable)type.newInstance();
                        object.readExternal(element);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                throw new InvalidDataException(ex);
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) throws InvalidDataException {
        Color color;
        if (value == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value, ex);
                throw new InvalidDataException("Wrong color value: " + value, ex);
            }
        }
        return color;
    }

    @ApiStatus.Internal
    public static void clearFieldCache() {
        ourFieldCache.clear();
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

