/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposableWrapper<T extends Disposable>
implements Disposable {
    private volatile T myObject;

    public DisposableWrapper(@Nullable T object, @NotNull Disposable parent) {
        this.myObject = object;
        Disposer.register(parent, this);
    }

    @NotNull
    public DisposableWrapper<T> moveTo(@NotNull Disposable parent) {
        DisposableWrapper<T> newWrapper = this.createNewWrapper(this.myObject, parent);
        this.myObject = null;
        return newWrapper;
    }

    @NotNull
    protected DisposableWrapper<T> createNewWrapper(@Nullable T object, @NotNull Disposable parent) {
        return new DisposableWrapper<T>(object, parent);
    }

    @Override
    public void dispose() {
        if (this.myObject != null) {
            Disposer.dispose(this.myObject);
        }
    }
}

