/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.StartUpMeasurer;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public enum LoadingState {
    BOOTSTRAP("bootstrap"),
    LAF_INITIALIZED("LaF is initialized"),
    COMPONENTS_REGISTERED("app component registered"),
    CONFIGURATION_STORE_INITIALIZED("app store initialized"),
    COMPONENTS_LOADED("app component loaded"),
    APP_STARTED("app started"),
    PROJECT_OPENED("project opened"),
    INDEXING_FINISHED("indexing finished");

    final String displayName;
    private static BiConsumer<String, Throwable> errorHandler;
    private static boolean CHECK_LOADING_PHASE;
    private static Set<Throwable> stackTraces;

    private LoadingState(String displayName) {
        this.displayName = displayName;
    }

    @Nullable
    static BiConsumer<String, Throwable> getErrorHandler() {
        return errorHandler;
    }

    @ApiStatus.Internal
    public static void setErrorHandler(@NotNull BiConsumer<String, Throwable> errorHandler) {
        LoadingState.errorHandler = errorHandler;
    }

    @ApiStatus.Internal
    public static void setStrictMode() {
        CHECK_LOADING_PHASE = true;
    }

    public void checkOccurred() {
        if (!CHECK_LOADING_PHASE) {
            return;
        }
        LoadingState currentState = StartUpMeasurer.currentState.get();
        if (currentState.compareTo(this) >= 0 || LoadingState.isKnownViolator()) {
            return;
        }
        this.logStateError(currentState);
    }

    private synchronized void logStateError(@NotNull LoadingState currentState) {
        Throwable t = new Throwable();
        if (stackTraces == null) {
            stackTraces = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Throwable>(){

                public int hashCode(Throwable throwable) {
                    return this.fingerprint(throwable).hashCode();
                }

                public boolean equals(Throwable o1, Throwable o2) {
                    return o1 == o2 || o1 != null && o2 != null && this.fingerprint(o1).equals(this.fingerprint(o2));
                }

                private String fingerprint(Throwable throwable) {
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement traceElement : throwable.getStackTrace()) {
                        sb.append(traceElement.getClassName()).append(traceElement.getMethodName());
                    }
                    return sb.toString();
                }
            });
        }
        if (!stackTraces.add(t)) {
            return;
        }
        BiConsumer<String, Throwable> errorHandler = LoadingState.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.accept("Should be called at least in the state " + (Object)((Object)this) + ", the current state is: " + (Object)((Object)currentState) + "\nCurrent violators count: " + stackTraces.size() + "\n\n", t);
        }
    }

    private static boolean isKnownViolator() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("com.intellij.util.indexing.IndexInfrastructure") && !className.contains("com.intellij.psi.impl.search.IndexPatternSearcher") && !className.contains("com.jetbrains.performancePlugin.ProjectLoaded") && !className.contains("com.jetbrains.python.conda.InstallCondaUtils")) continue;
            return true;
        }
        return false;
    }

    public boolean isOccurred() {
        return StartUpMeasurer.currentState.get().compareTo(this) >= 0;
    }
}

