/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.DomElementPattern;
import com.intellij.patterns.DomFilePattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.GenericDomValuePattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.XmlElementPattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import org.jetbrains.annotations.NotNull;

public class DomPatterns {
    public static <T extends DomElement> DomElementPattern.Capture<T> domElement(Class<T> aClass) {
        return new DomElementPattern.Capture<T>(aClass);
    }

    public static DomElementPattern.Capture<DomElement> domElement() {
        return DomPatterns.domElement(DomElement.class);
    }

    public static GenericDomValuePattern<?> genericDomValue() {
        return new GenericDomValuePattern();
    }

    public static <T> GenericDomValuePattern<T> genericDomValue(ElementPattern<?> valuePattern) {
        return DomPatterns.genericDomValue().withValue(valuePattern);
    }

    public static <T> GenericDomValuePattern<T> genericDomValue(Class<T> aClass) {
        return new GenericDomValuePattern<T>(aClass);
    }

    @Deprecated
    public static XmlElementPattern.Capture withDom(final ElementPattern<? extends DomElement> pattern) {
        return (XmlElementPattern.Capture)new XmlElementPattern.Capture().with((PatternCondition)new PatternCondition<XmlElement>("tagWithDom"){

            public boolean accepts(@NotNull XmlElement xmlElement, ProcessingContext context) {
                DomManager manager = DomManager.getDomManager(xmlElement.getProject());
                if (xmlElement instanceof XmlAttribute) {
                    return pattern.accepts(manager.getDomElement((XmlAttribute)xmlElement), context);
                }
                return xmlElement instanceof XmlTag && pattern.accepts((Object)manager.getDomElement((XmlTag)xmlElement), context);
            }
        });
    }

    public static <T extends DomElement> DomFilePattern.Capture inDomFile(Class<T> rootElementClass) {
        return new DomFilePattern.Capture(rootElementClass);
    }

    public static XmlTagPattern.Capture tagWithDom(String tagName, Class<? extends DomElement> aClass) {
        return DomPatterns.tagWithDom(tagName, DomPatterns.domElement(aClass));
    }

    public static XmlTagPattern.Capture tagWithDom(String tagName, ElementPattern<? extends DomElement> domPattern) {
        return (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(tagName)).and((ElementPattern)DomPatterns.withDom(domPattern));
    }

    public static XmlTagPattern.Capture tagWithDom(String[] tagNames, ElementPattern<? extends DomElement> domPattern) {
        return (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(tagNames)).and((ElementPattern)DomPatterns.withDom(domPattern));
    }

    public static XmlNamedElementPattern.XmlAttributePattern attributeWithDom(String attributeName, ElementPattern<? extends DomElement> domPattern) {
        return (XmlNamedElementPattern.XmlAttributePattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withLocalName(attributeName)).and((ElementPattern)DomPatterns.withDom(domPattern));
    }

    public static PsiElementPattern.Capture<PomTargetPsiElement> domTargetElement(ElementPattern<? extends DomElement> pattern) {
        return PlatformPatterns.pomElement(DomPatterns.withDomTarget(pattern));
    }

    public static ElementPattern<DomTarget> withDomTarget(final ElementPattern<? extends DomElement> pattern) {
        return new ObjectPattern.Capture(DomTarget.class).with((PatternCondition)new PatternCondition<DomTarget>("withDomTarget"){

            public boolean accepts(@NotNull DomTarget target, ProcessingContext context) {
                return pattern.accepts((Object)target.getDomElement(), context);
            }
        });
    }
}

