/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceObsoleteLabelSyntaxFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "element", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class ReplaceObsoleteLabelSyntaxFix
extends KotlinQuickFixAction<KtAnnotationEntry>
implements CleanupFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("update.obsolete.label.syntax", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object object;
        block5: {
            block4: {
                object = (KtAnnotationEntry)this.getElement();
                if (object == null) break block4;
                KtAnnotationEntry ktAnnotationEntry = object;
                boolean bl = false;
                boolean bl2 = false;
                KtAnnotationEntry it = ktAnnotationEntry;
                boolean bl3 = false;
                Object[] objectArray = new Object[1];
                Object object2 = it.getCalleeExpression();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    object2 = objectArray[0] = "";
                }
                if ((object = KotlinBundle.message("replace.with.label.0.at", objectArray)) != null) break block5;
            }
            object = "";
        }
        return object;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        ReplaceObsoleteLabelSyntaxFix.Companion.replaceWithLabel(ktAnnotationEntry);
    }

    public ReplaceObsoleteLabelSyntaxFix(@NotNull KtAnnotationEntry element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceObsoleteLabelSyntaxFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "looksLikeObsoleteLabel", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "replaceWithLabel", "", "annotation", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$getNonStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtAnnotationEntry.class, (boolean)false);
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
            if (!this.looksLikeObsoleteLabel(annotationEntry2)) {
                return null;
            }
            return new ReplaceObsoleteLabelSyntaxFix(annotationEntry2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean looksLikeObsoleteLabel(@NotNull KtAnnotationEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            if (entry.getAtSymbol() == null) return false;
            if (!(entry.getParent() instanceof KtAnnotatedExpression)) return false;
            PsiElement psiElement2 = entry.getParent();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotatedExpression");
            }
            if (((KtAnnotatedExpression)psiElement2).getAnnotationEntries().size() != 1) return false;
            if (entry.getValueArgumentList() != null) return false;
            KtConstructorCalleeExpression ktConstructorCalleeExpression = entry.getCalleeExpression();
            KtConstructorCalleeExpression ktConstructorCalleeExpression2 = ktConstructorCalleeExpression;
            if (ktConstructorCalleeExpression == null) return false;
            KtSimpleNameExpression ktSimpleNameExpression = ktConstructorCalleeExpression2.getConstructorReferenceExpression();
            ktConstructorCalleeExpression2 = ktSimpleNameExpression;
            if (ktSimpleNameExpression == null) return false;
            PsiElement psiElement3 = ktConstructorCalleeExpression2.getIdentifier();
            if (psiElement3 == null) return false;
            return true;
        }

        private final void replaceWithLabel(KtAnnotationEntry annotation) {
            Object object = annotation.getCalleeExpression();
            if (object == null || (object = object.getConstructorReferenceExpression()) == null || (object = object.getReferencedName()) == null) {
                return;
            }
            Object labelName2 = object;
            PsiElement psiElement2 = annotation.getParent();
            if (!(psiElement2 instanceof KtAnnotatedExpression)) {
                psiElement2 = null;
            }
            KtAnnotatedExpression ktAnnotatedExpression = (KtAnnotatedExpression)psiElement2;
            if (ktAnnotatedExpression == null) {
                return;
            }
            KtAnnotatedExpression annotatedExpression = ktAnnotatedExpression;
            KtExpression ktExpression = annotatedExpression.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"annotatedExpression.baseExpression ?: return");
            KtExpression expression2 = ktExpression;
            if (annotatedExpression.getAnnotationEntries().size() != 1) {
                return;
            }
            TextRange textRange = expression2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expression.textRange");
            int baseExpressionStart = textRange.getStartOffset();
            TextRange textRange2 = annotation.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"annotation.textRange");
            TextRange textRangeToRetain = new TextRange(textRange2.getEndOffset(), baseExpressionStart);
            PsiFile psiFile = annotation.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"annotation.containingFile");
            String string = textRangeToRetain.substring(psiFile.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textRangeToRetain.substr\u2026tion.containingFile.text)");
            String textToRetain = string;
            KtExpression labeledExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)annotation), (boolean)false, (int)2, null), (String)"$0@$1$2", (Object[])new Object[]{labelName2, textToRetain, expression2}, (boolean)false, (int)4, null);
            annotatedExpression.replace((PsiElement)labeledExpression);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

