/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.SimplifyBooleanWithConstantsIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0015\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u001d\u0010\u0018\u001a\u00020\n*\u00020\u000b2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u000bH\u0002J\u000e\u0010\u001d\u001a\u00020\n*\u0004\u0018\u00010\u000bH\u0002J\f\u0010\u001e\u001a\u00020\u0002*\u00020\u0002H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "areThereExpressionsToBeSimplified", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isApplicableTo", "isPositiveNegativeZeroComparison", "removeRedundantAssertion", "expression", "removeRedundantAssertion$kotlin_idea", "simplifyExpression", "toSimplifiedBooleanBinaryExpressionWithConstantOperand", "constantOperand", "otherOperand", "operation", "Lcom/intellij/psi/tree/IElementType;", "toSimplifiedExpression", "canBeReducedToBooleanConstant", "constant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Boolean;)Z", "canBeReducedToFalse", "canBeReducedToTrue", "hasBooleanType", "topBinary", "kotlin.idea"})
public final class SimplifyBooleanWithConstantsIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return this.areThereExpressionsToBeSimplified((KtExpression)this.topBinary(element3));
    }

    private final KtBinaryExpression topBinary(KtBinaryExpression $this$topBinary) {
        KtBinaryExpression ktBinaryExpression;
        Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)$this$topBinary)), (Function1)topBinary.1.INSTANCE));
        if (!(object instanceof KtBinaryExpression)) {
            object = null;
        }
        if ((ktBinaryExpression = (KtBinaryExpression)object) == null) {
            ktBinaryExpression = $this$topBinary;
        }
        return ktBinaryExpression;
    }

    private final boolean areThereExpressionsToBeSimplified(KtExpression element3) {
        if (element3 == null) {
            return false;
        }
        KtExpression ktExpression = element3;
        if (ktExpression instanceof KtParenthesizedExpression) {
            return this.areThereExpressionsToBeSimplified(((KtParenthesizedExpression)element3).getExpression());
        }
        if (ktExpression instanceof KtBinaryExpression) {
            IElementType iElementType = ((KtBinaryExpression)element3).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"element.operationToken");
            IElementType op = iElementType;
            if (Intrinsics.areEqual((Object)op, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)op, (Object)KtTokens.OROR) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EXCLEQ)) {
                if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element3).getLeft()) && this.hasBooleanType(((KtBinaryExpression)element3).getRight())) {
                    return true;
                }
                if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element3).getRight()) && this.hasBooleanType(((KtBinaryExpression)element3).getLeft())) {
                    return true;
                }
            }
            if (this.isPositiveNegativeZeroComparison((KtBinaryExpression)element3)) {
                return false;
            }
        }
        return SimplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant$default(this, element3, null, 1, null);
    }

    private final boolean isPositiveNegativeZeroComparison(KtBinaryExpression element3) {
        IElementType iElementType = element3.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"element.operationToken");
        IElementType op = iElementType;
        if (Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) ^ true && Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQEQ) ^ true) {
            return false;
        }
        KtExpression ktExpression = element3.getLeft();
        Object object = ktExpression != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression)) : null;
        if (!(object instanceof KtExpression)) {
            object = null;
        }
        KtExpression ktExpression2 = (KtExpression)object;
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression left = ktExpression2;
        KtExpression ktExpression3 = element3.getRight();
        Object object2 = ktExpression3 != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression3)) : null;
        if (!(object2 instanceof KtExpression)) {
            object2 = null;
        }
        KtExpression ktExpression4 = (KtExpression)object2;
        if (ktExpression4 == null) {
            return false;
        }
        KtExpression right = ktExpression4;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)element3), (BodyResolveMode)BodyResolveMode.PARTIAL);
        Function1<KtExpression, Object> $fun$getConstantValue$1 = new Function1<KtExpression, Object>(context2){
            final /* synthetic */ BindingContext $context;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invoke(@NotNull KtExpression $this$getConstantValue) {
                Intrinsics.checkNotNullParameter((Object)$this$getConstantValue, (String)"$this$getConstantValue");
                CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant($this$getConstantValue, this.$context);
                CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
                if (compileTimeConstant == null) return null;
                SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"TypeUtils.NO_EXPECTED_TYPE");
                ConstantValue constantValue = compileTimeConstant2.toConstantValue((KotlinType)simpleType);
                compileTimeConstant2 = constantValue;
                if (constantValue == null) return null;
                Object object = compileTimeConstant2.getValue();
                return object;
            }
            {
                this.$context = bindingContext2;
                super(1);
            }
        };
        Object leftValue = $fun$getConstantValue$1.invoke(left);
        Object rightValue = $fun$getConstantValue$1.invoke(right);
        isPositiveNegativeZeroComparison.2 $fun$isPositiveZero$2 = isPositiveNegativeZeroComparison.2.INSTANCE;
        isPositiveNegativeZeroComparison.3 $fun$isNegativeZero$3 = isPositiveNegativeZeroComparison.3.INSTANCE;
        boolean hasPositiveZero = $fun$isPositiveZero$2.invoke(leftValue) || $fun$isPositiveZero$2.invoke(rightValue);
        boolean hasNegativeZero = $fun$isNegativeZero$3.invoke(leftValue) || $fun$isNegativeZero$3.invoke(rightValue);
        return hasPositiveZero && hasNegativeZero;
    }

    /*
     * WARNING - void declaration
     */
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        PsiElement psiElement2;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtBinaryExpression topBinary2 = this.topBinary(element3);
        KtExpression simplified = this.toSimplifiedExpression((KtExpression)topBinary2);
        PsiElement psiElement3 = (PsiElement)topBinary2;
        PsiElement newElement$iv = (PsiElement)KtPsiUtil.safeDeparenthesize((KtExpression)simplified, (boolean)true);
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
        PsiElement psiElement4 = result$iv;
        if (!(psiElement4 instanceof KtExpression)) {
            psiElement4 = null;
        }
        if ((psiElement2 = (PsiElement)((KtExpression)psiElement4)) == null) {
            PsiElement psiElement5 = result$iv;
            if (psiElement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            psiElement2 = (PsiElement)ktExpression;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"topBinary.replaced(KtPsi\u2026hesize(simplified, true))");
        KtExpression result2 = (KtExpression)psiElement2;
        this.removeRedundantAssertion$kotlin_idea(result2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeRedundantAssertion$kotlin_idea(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)expression2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) return;
        KtCallExpression callExpression2 = ktCallExpression;
        CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor((KtExpression)callExpression2);
        FqName fqName = callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null;
        List list = callExpression2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callExpression.valueArguments");
        List valueArguments = list;
        FqName fqName2 = fqName;
        if (!Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)"kotlin.assert")) return;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)valueArguments);
        if (!CommonUtilsKt.isTrueConstant((KtExpression)(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null))) return;
        boolean bl = true;
        boolean isRedundant = bl;
        if (!isRedundant) return;
        callExpression2.delete();
    }

    private final KtExpression toSimplifiedExpression(KtExpression expression2) {
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)expression2), (boolean)false, (int)2, null);
        if (this.canBeReducedToTrue(expression2)) {
            return psiFactory.createExpression("true");
        }
        if (this.canBeReducedToFalse(expression2)) {
            return psiFactory.createExpression("false");
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            KtExpression expr2 = ((KtParenthesizedExpression)expression2).getExpression();
            if (expr2 != null) {
                KtExpression simplified = this.toSimplifiedExpression(expr2);
                return simplified instanceof KtBinaryExpression ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"($0)", (Object[])new Object[]{simplified}, (boolean)false, (int)4, null) : simplified;
            }
        } else if (expression2 instanceof KtBinaryExpression) {
            if (!this.areThereExpressionsToBeSimplified(expression2)) {
                return (KtExpression)FrontendIndependentPsiUtilsKt.copied((PsiElement)((PsiElement)expression2));
            }
            KtExpression left = ((KtBinaryExpression)expression2).getLeft();
            KtExpression right = ((KtBinaryExpression)expression2).getRight();
            IElementType iElementType = ((KtBinaryExpression)expression2).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expression.operationToken");
            IElementType op = iElementType;
            if (left != null && right != null && (Intrinsics.areEqual((Object)op, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)op, (Object)KtTokens.OROR) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)op, (Object)KtTokens.EXCLEQ))) {
                KtExpression ktExpression;
                KtExpression simpleLeft = this.simplifyExpression(left);
                KtExpression simpleRight = this.simplifyExpression(right);
                if (this.canBeReducedToTrue(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleRight, op);
                } else if (this.canBeReducedToFalse(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleRight, op);
                } else if (this.canBeReducedToTrue(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleLeft, op);
                } else if (this.canBeReducedToFalse(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleLeft, op);
                } else {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)expression2).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                    String opText = ktOperationReferenceExpression.getText();
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0 " + opText + " $1"), (Object[])new Object[]{simpleLeft, simpleRight}, (boolean)false, (int)4, null);
                }
                return ktExpression;
            }
        }
        return (KtExpression)FrontendIndependentPsiUtilsKt.copied((PsiElement)((PsiElement)expression2));
    }

    private final KtExpression toSimplifiedBooleanBinaryExpressionWithConstantOperand(boolean constantOperand, KtExpression otherOperand, IElementType operation2) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)otherOperand), (boolean)false, (int)2, null);
        IElementType iElementType = operation2;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
            if (constantOperand) {
                return factory2.createExpression("true");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
            if (!constantOperand) {
                return factory2.createExpression("false");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            KtExpression ktExpression = this.toSimplifiedExpression(otherOperand);
            boolean bl = false;
            boolean bl2 = false;
            KtExpression it = ktExpression;
            boolean bl3 = false;
            return constantOperand == Intrinsics.areEqual((Object)operation2, (Object)KtTokens.EQEQ) ? it : CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"!$0", (Object[])new Object[]{it}, (boolean)false, (int)4, null);
        }
        return this.toSimplifiedExpression(otherOperand);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression simplifyExpression(KtExpression expression2) {
        PsiElement psiElement2;
        void $this$replaced$iv;
        PsiElement psiElement3 = (PsiElement)expression2;
        PsiElement newElement$iv = (PsiElement)this.toSimplifiedExpression(expression2);
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
        PsiElement psiElement4 = result$iv;
        if (!(psiElement4 instanceof KtExpression)) {
            psiElement4 = null;
        }
        if ((psiElement2 = (PsiElement)((KtExpression)psiElement4)) == null) {
            PsiElement psiElement5 = result$iv;
            if (psiElement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            psiElement2 = (PsiElement)ktExpression;
        }
        return (KtExpression)psiElement2;
    }

    private final boolean hasBooleanType(KtExpression $this$hasBooleanType) {
        KtExpression ktExpression = $this$hasBooleanType;
        if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)$this$hasBooleanType), (BodyResolveMode)BodyResolveMode.PARTIAL))) == null) {
            return false;
        }
        KtExpression type2 = ktExpression;
        return KotlinBuiltIns.isBoolean((KotlinType)type2) && !FlexibleTypesKt.isFlexible((KotlinType)type2);
    }

    private final boolean canBeReducedToBooleanConstant(KtExpression $this$canBeReducedToBooleanConstant, Boolean constant) {
        return CompileTimeConstantUtils.canBeReducedToBooleanConstant((KtExpression)$this$canBeReducedToBooleanConstant, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)$this$canBeReducedToBooleanConstant), (BodyResolveMode)BodyResolveMode.PARTIAL), (Boolean)constant);
    }

    static /* synthetic */ boolean canBeReducedToBooleanConstant$default(SimplifyBooleanWithConstantsIntention simplifyBooleanWithConstantsIntention, KtExpression ktExpression, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return simplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant(ktExpression, bl);
    }

    private final boolean canBeReducedToTrue(KtExpression $this$canBeReducedToTrue) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToTrue, true);
    }

    private final boolean canBeReducedToFalse(KtExpression $this$canBeReducedToFalse) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToFalse, false);
    }

    public SimplifyBooleanWithConstantsIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage("simplify.boolean.expression", new Object[0]), null, 4, null);
    }
}

