/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/NonBlockingContextChecker;", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isContextNonBlockingFor", "element", "Lcom/intellij/psi/PsiElement;", "getFirstArgument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Companion", "kotlin.idea"})
public final class CoroutineNonBlockingContextChecker
implements NonBlockingContextChecker {
    private static final String BLOCKING_CONTEXT_ANNOTATION = "org.jetbrains.annotations.BlockingContext";
    private static final String IO_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.IO";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings$default((Project)project2, null, null, (int)3, null);
        return languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    public boolean isContextNonBlockingFor(@NotNull PsiElement element3) {
        Object v0;
        block14: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (!(element3 instanceof KtCallExpression)) {
                return false;
            }
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtLambdaExpression && ResolutionUtils.analyze$default((KtElement)((KtElement)it), null, (int)1, null).get((ReadOnlySlice)BindingContext.LAMBDA_INVOCATIONS, (Object)it) == null)) continue;
                v0 = element$iv;
                break block14;
            }
            v0 = null;
        }
        PsiElement containingLambda = v0;
        KtValueArgument containingArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)containingLambda, KtValueArgument.class);
        if (containingArgument != null) {
            Boolean bl;
            Boolean hasBlockingAnnotation;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)containingArgument), KtCallExpression.class);
            if (ktCallExpression == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktCallExpression, (String)"PsiTreeUtil.getParentOfT\u2026ass.java) ?: return false");
            KtCallExpression callExpression2 = ktCallExpression;
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)((KtElement)callExpression2), (BodyResolveMode)BodyResolveMode.PARTIAL);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall call = resolvedCall2;
            KtExpression ktExpression = this.getFirstArgument(call);
            CallableDescriptor argumentDescriptor = ktExpression != null && (ktExpression = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)ktExpression), null, (int)1, null)) != null ? ktExpression.getResultingDescriptor() : null;
            CallableDescriptor callableDescriptor = argumentDescriptor;
            Boolean bl2 = callableDescriptor != null && (callableDescriptor = callableDescriptor.getAnnotations()) != null ? Boolean.valueOf(callableDescriptor.hasAnnotation(new FqName(BLOCKING_CONTEXT_ANNOTATION))) : (hasBlockingAnnotation = null);
            if (Intrinsics.areEqual(hasBlockingAnnotation, (Object)true)) {
                return false;
            }
            CallableDescriptor callableDescriptor2 = argumentDescriptor;
            boolean isIoDispatcherUsed = Intrinsics.areEqual(callableDescriptor2 != null && (callableDescriptor2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor2))) != null ? callableDescriptor2.asString() : null, (Object)IO_DISPATCHER_FQN);
            if (isIoDispatcherUsed) {
                return false;
            }
            ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument((ResolvedCall)call, (ValueArgument)((ValueArgument)containingArgument));
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor parameterForArgument = valueParameterDescriptor;
            KotlinType kotlinType = parameterForArgument.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameterForArgument.returnType ?: return false");
            KotlinType type2 = kotlinType;
            if (FunctionTypesKt.isBuiltinFunctionalType((KotlinType)type2)) {
                KotlinType kotlinType2 = FunctionTypesKt.getReceiverTypeFromFunctionType((KotlinType)type2);
                if (kotlinType2 != null) {
                    Project project2 = ((KtCallExpression)element3).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
                    bl = CoroutineCallCheckerKt.isRestrictsSuspensionReceiver((KotlinType)kotlinType2, (LanguageVersionSettings)PlatformKt.getLanguageVersionSettings$default((Project)project2, null, null, (int)3, null));
                } else {
                    bl = null;
                }
            } else {
                bl = null;
            }
            Boolean hasRestrictSuspensionAnnotation = bl;
            return Intrinsics.areEqual(hasRestrictSuspensionAnnotation, (Object)true) ^ true && FunctionTypesKt.isSuspendFunctionType((KotlinType)type2);
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)element3, KtNamedFunction.class);
        if (ktNamedFunction == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktNamedFunction, (String)"PsiTreeUtil.getParentOfT\u2026ass.java) ?: return false");
        KtNamedFunction callingMethod = ktNamedFunction;
        return callingMethod.hasModifier(KtTokens.SUSPEND_KEYWORD);
    }

    private final KtExpression getFirstArgument(ResolvedCall<?> $this$getFirstArgument) {
        List list = $this$getFirstArgument.getValueArgumentsByIndex();
        return list != null && (list = (ResolvedValueArgument)CollectionsKt.firstOrNull((List)list)) != null && (list = list.getArguments()) != null && (list = (ValueArgument)CollectionsKt.firstOrNull((List)list)) != null ? list.getArgumentExpression() : null;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineNonBlockingContextChecker$Companion;", "", "()V", "BLOCKING_CONTEXT_ANNOTATION", "", "IO_DISPATCHER_FQN", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

