/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"isKeyword", "", "text", "", "isRedundantBackticks", "node", "Lcom/intellij/lang/ASTNode;", "kotlin.idea"})
public final class RemoveRedundantBackticksInspectionKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKeyword(String text2) {
        int n;
        Object[] objectArray;
        block4: {
            if (Intrinsics.areEqual((Object)text2, (Object)"yield")) return true;
            Object[] $this$all$iv = (Object[])text2;
            boolean $i$f$all = false;
            objectArray = $this$all$iv;
            n = 0;
            while (n < objectArray.length()) {
                char element$iv;
                char it = element$iv = objectArray.charAt(n);
                boolean bl = false;
                if (it == '_') {
                    ++n;
                    continue;
                }
                break block4;
            }
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        TokenSet tokenSet = KtTokens.KEYWORDS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"KtTokens.KEYWORDS");
        Object[] objectArray2 = tokenSet.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"KtTokens.KEYWORDS.types");
        TokenSet tokenSet2 = KtTokens.SOFT_KEYWORDS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"KtTokens.SOFT_KEYWORDS");
        Object[] objectArray3 = tokenSet2.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"KtTokens.SOFT_KEYWORDS.types");
        Object[] $this$any$iv = ArraysKt.plus((Object[])objectArray2, (Object[])objectArray3);
        boolean $i$f$any = false;
        objectArray = $this$any$iv;
        n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element$iv = objectArray[n2];
            IElementType it = (IElementType)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.toString(), (Object)text2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final boolean isRedundantBackticks(ASTNode node) {
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        String identifier = string;
        if (!StringsKt.startsWith$default((String)identifier, (String)"`", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)identifier, (String)"`", (boolean)false, (int)2, null)) {
            return false;
        }
        String unquotedText = FrontendIndependentPsiUtilsKt.unquote((String)identifier);
        if (!KtPsiUtilKt.isIdentifier((String)unquotedText) || RemoveRedundantBackticksInspectionKt.isKeyword(unquotedText)) {
            return false;
        }
        PsiElement psiElement2 = node.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"node.psi");
        PsiElement $this$getStrictParentOfType$iv = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtSimpleNameStringTemplateEntry simpleNameStringTemplateEntry = (KtSimpleNameStringTemplateEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSimpleNameStringTemplateEntry.class, (boolean)true);
        return simpleNameStringTemplateEntry == null || KtPsiUtilKt.canPlaceAfterSimpleNameEntry((PsiElement)simpleNameStringTemplateEntry.getNextSibling());
    }

    public static final /* synthetic */ boolean access$isRedundantBackticks(ASTNode node) {
        return RemoveRedundantBackticksInspectionKt.isRedundantBackticks(node);
    }
}

