/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveRequireNotNullCallFix;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.resolve.FrontendServiceHelpersKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\t\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantRequireNotNullCallInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isNullable", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kotlin.idea"})
public final class RedundantRequireNotNullCallInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1)((Function1)new Function1<KtCallExpression, Unit>(this, holder){
            final /* synthetic */ RedundantRequireNotNullCallInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression callExpression2) {
                Intrinsics.checkNotNullParameter((Object)callExpression2, (String)"callExpression");
                KtExpression ktExpression = callExpression2.getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"callExpression.calleeExpression ?: return");
                KtExpression callee = ktExpression;
                ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)callExpression2));
                BindingContext context2 = ExtendedResolutionApiKt.analyze((KtElement)((KtElement)callExpression2), (ResolutionFacade)resolutionFacade2, (BodyResolveMode)BodyResolveMode.PARTIAL);
                if (!FunctionUtilsKt.isCalling(callExpression2, new FqName("kotlin.requireNotNull"), context2) && !FunctionUtilsKt.isCalling(callExpression2, new FqName("kotlin.checkNotNull"), context2)) {
                    return;
                }
                List list = callExpression2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callExpression.valueArguments");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list);
                if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null || (ktValueArgument = KtPsiUtilKt.referenceExpression((KtExpression)ktValueArgument)) == null) {
                    return;
                }
                KtValueArgument argument2 = ktValueArgument;
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)argument2), (BindingContext)context2);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall descriptor2 = resolvedCall2;
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.returnType ?: return");
                KotlinType type2 = kotlinType;
                if (RedundantRequireNotNullCallInspection.access$isNullable(this.this$0, (KtReferenceExpression)argument2, (CallableDescriptor)descriptor2, type2, context2, resolutionFacade2)) {
                    return;
                }
                String functionName = callee.getText();
                PsiElement psiElement2 = (PsiElement)callee;
                Object[] objectArray = new Object[1];
                String string = functionName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionName");
                objectArray[0] = string;
                this.$holder.registerProblem(psiElement2, KotlinBundle.message("redundant.0.call", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveRequireNotNullCallFix(functionName)});
            }
            {
                this.this$0 = redundantRequireNotNullCallInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean isNullable(KtReferenceExpression $this$isNullable, CallableDescriptor descriptor2, KotlinType type2, BindingContext context2, ResolutionFacade resolutionFacade2) {
        boolean bl;
        block4: {
            if (!KotlinTypeKt.isNullable((KotlinType)type2)) {
                return false;
            }
            DataFlowValueFactory dataFlowValueFactory = FrontendServiceHelpersKt.getDataFlowValueFactory((ResolutionFacade)resolutionFacade2);
            DataFlowValue dataFlow = dataFlowValueFactory.createDataFlowValue((KtExpression)$this$isNullable, type2, context2, (DeclarationDescriptor)descriptor2);
            Set stableTypes = BindingContextUtilsKt.getDataFlowInfoBefore((BindingContext)context2, (PsiElement)((PsiElement)$this$isNullable)).getStableTypes(dataFlow, PlatformKt.getLanguageVersionSettings((PsiElement)((PsiElement)$this$isNullable)));
            Iterable $this$none$iv = stableTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!(!KotlinTypeKt.isNullable((KotlinType)it))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isNullable(RedundantRequireNotNullCallInspection $this, KtReferenceExpression $this$access_u24isNullable, CallableDescriptor descriptor2, KotlinType type2, BindingContext context2, ResolutionFacade resolutionFacade2) {
        return $this.isNullable($this$access_u24isNullable, descriptor2, type2, context2, resolutionFacade2);
    }
}

