/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.NullChecksToSafeCallInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullChecksToSafeCallInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "NullChecksToSafeCallCheckFix", "kotlin.idea"})
public final class NullChecksToSafeCallInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return VisitorWrappersKt.binaryExpressionVisitor((Function1)((Function1)new Function1<KtBinaryExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtBinaryExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (org.jetbrains.kotlin.idea.inspections.NullChecksToSafeCallInspection$Companion.access$isNullChecksToSafeCallFixAvailable(NullChecksToSafeCallInspection.Companion, expression2)) {
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("null.checks.replaceable.with.safe.calls", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new NullChecksToSafeCallCheckFix()});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullChecksToSafeCallInspection$NullChecksToSafeCallCheckFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class NullChecksToSafeCallCheckFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("null.checks.to.safe.call.check.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
            if (ktBinaryExpression == null) {
                return;
            }
            this.applyFix(ktBinaryExpression);
        }

        /*
         * WARNING - void declaration
         */
        private final void applyFix(KtBinaryExpression expression2) {
            PsiElement psiElement2;
            PsiElement psiElement3;
            void $this$replaced$iv;
            void rte;
            void lte;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)expression2)) {
                return;
            }
            Triple triple = Companion.collectNullCheckExpressions(expression2);
            if (triple == null) {
                return;
            }
            Triple triple2 = triple;
            KtExpression ktExpression = (KtExpression)triple2.component1();
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)triple2.component2();
            boolean isAnd = (Boolean)triple2.component3();
            PsiElement parent2 = expression2.getParent();
            PsiElement psiElement4 = (PsiElement)expression2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.buildExpression$default((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)lte), (boolean)false, (int)2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>((KtExpression)lte, (KtQualifiedExpression)rte, isAnd){
                final /* synthetic */ KtExpression $lte;
                final /* synthetic */ KtQualifiedExpression $rte;
                final /* synthetic */ boolean $isAnd;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                    Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                    $this$buildExpression.appendExpression(this.$lte);
                    $this$buildExpression.appendFixedText("?.");
                    $this$buildExpression.appendExpression(this.$rte.getSelectorExpression());
                    $this$buildExpression.appendFixedText(this.$isAnd ? "!= null" : "== null");
                }
                {
                    this.$lte = ktExpression;
                    this.$rte = ktQualifiedExpression;
                    this.$isAnd = bl;
                    super(1);
                }
            }), (int)1, null);
            boolean $i$f$replaced = false;
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            PsiElement psiElement5 = result$iv;
            if (!(psiElement5 instanceof KtExpression)) {
                psiElement5 = null;
            }
            if ((psiElement3 = (PsiElement)((KtExpression)psiElement5)) == null) {
                PsiElement psiElement6 = result$iv;
                if (psiElement6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement6).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement3 = (PsiElement)ktExpression2;
            }
            if (!((psiElement2 = parent2) instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
            if (ktBinaryExpression == null) {
                return;
            }
            if (Companion.isNullChecksToSafeCallFixAvailable(ktBinaryExpression)) {
                this.applyFix((KtBinaryExpression)parent2);
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullChecksToSafeCallInspection$Companion;", "", "()V", "collectNullCheckExpressions", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isNullChecksToSafeCallFixAvailable", "getNullTestableExpression", "expectedOperation", "Lorg/jetbrains/kotlin/lexer/KtToken;", "isChainStable", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final boolean isNullChecksToSafeCallFixAvailable(KtBinaryExpression expression2) {
            void lte;
            isNullChecksToSafeCallFixAvailable.1 $fun$afterIgnoreCalls$1 = isNullChecksToSafeCallFixAvailable.1.INSTANCE;
            Triple<KtExpression, KtQualifiedExpression, Boolean> triple = this.collectNullCheckExpressions(expression2);
            if (triple == null) {
                return false;
            }
            Triple<KtExpression, KtQualifiedExpression, Boolean> triple2 = triple;
            KtExpression ktExpression = (KtExpression)triple2.component1();
            KtQualifiedExpression rte = (KtQualifiedExpression)triple2.component2();
            BindingContext context2 = ResolutionUtils.analyze$default((KtElement)((KtElement)expression2), null, (int)1, null);
            if (!this.isChainStable((KtExpression)lte, context2)) {
                return false;
            }
            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)rte), (BindingContext)context2);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            ReceiverValue extensionReceiver = resolvedCall3.getExtensionReceiver();
            if (extensionReceiver != null && TypeUtils.isNullableType((KotlinType)extensionReceiver.getType())) {
                return false;
            }
            String string = rte.getReceiverExpression().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rte.receiverExpression.text");
            String string2 = $fun$afterIgnoreCalls$1.invoke(string);
            String string3 = lte.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lte.text");
            return Intrinsics.areEqual((Object)string2, (Object)$fun$afterIgnoreCalls$1.invoke(string3));
        }

        private final Triple<KtExpression, KtQualifiedExpression, Boolean> collectNullCheckExpressions(KtBinaryExpression expression2) {
            KtSingleValueToken expectedOperation;
            boolean bl;
            IElementType iElementType = expression2.getOperationToken();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
                bl = false;
            } else {
                return null;
            }
            boolean isAnd = bl;
            KtExpression ktExpression = expression2.getLeft();
            if (!(ktExpression instanceof KtBinaryExpression)) {
                ktExpression = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression lhs = ktBinaryExpression;
            KtExpression ktExpression2 = expression2.getRight();
            if (!(ktExpression2 instanceof KtBinaryExpression)) {
                ktExpression2 = null;
            }
            KtBinaryExpression ktBinaryExpression2 = (KtBinaryExpression)ktExpression2;
            if (ktBinaryExpression2 == null) {
                return null;
            }
            KtBinaryExpression rhs = ktBinaryExpression2;
            KtSingleValueToken ktSingleValueToken = expectedOperation = isAnd ? KtTokens.EXCLEQ : KtTokens.EQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"expectedOperation");
            KtExpression ktExpression3 = this.getNullTestableExpression(lhs, (KtToken)ktSingleValueToken);
            if (ktExpression3 == null) {
                return null;
            }
            KtExpression lte = ktExpression3;
            KtExpression ktExpression4 = this.getNullTestableExpression(rhs, (KtToken)expectedOperation);
            if (!(ktExpression4 instanceof KtQualifiedExpression)) {
                ktExpression4 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression4;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression rte = ktQualifiedExpression;
            return new Triple((Object)lte, (Object)rte, (Object)isAnd);
        }

        private final KtExpression getNullTestableExpression(KtBinaryExpression $this$getNullTestableExpression, KtToken expectedOperation) {
            if (Intrinsics.areEqual((Object)$this$getNullTestableExpression.getOperationToken(), (Object)expectedOperation) ^ true) {
                return null;
            }
            KtExpression ktExpression = $this$getNullTestableExpression.getLeft();
            if (ktExpression == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"left ?: return null");
            KtExpression lhs = ktExpression;
            KtExpression ktExpression2 = $this$getNullTestableExpression.getRight();
            if (ktExpression2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"right ?: return null");
            KtExpression rhs = ktExpression2;
            if (KtPsiUtil.isNullConstant((KtExpression)lhs)) {
                return rhs;
            }
            if (KtPsiUtil.isNullConstant((KtExpression)rhs)) {
                return lhs;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isChainStable(KtExpression $this$isChainStable, BindingContext context2) {
            KtExpression ktExpression = $this$isChainStable;
            if (!(ktExpression instanceof KtReferenceExpression)) {
                if (!(ktExpression instanceof KtQualifiedExpression)) return false;
                KtExpression ktExpression2 = ((KtQualifiedExpression)$this$isChainStable).getSelectorExpression();
                if (ktExpression2 == null) return false;
                if (!IfThenUtilsKt.isStableSimpleExpression(ktExpression2, context2)) return false;
                if (!this.isChainStable(((KtQualifiedExpression)$this$isChainStable).getReceiverExpression(), context2)) return false;
                return true;
            }
            boolean bl = IfThenUtilsKt.isStableSimpleExpression($this$isChainStable, context2);
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

