/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MigrateDiagnosticSuppressionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "ReplaceDiagnosticNameFix", "kotlin.idea"})
public final class MigrateDiagnosticSuppressionInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    private static final Map<String, DiagnosticFactoryWithPsiElement<? extends KtElement, ? extends AbstractDiagnostic<? extends KtElement>>> MIGRATION_MAP;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.annotationEntryVisitor((Function1)((Function1)new Function1<KtAnnotationEntry, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtAnnotationEntry annotationEntry2) {
                Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
                KtConstructorCalleeExpression ktConstructorCalleeExpression = annotationEntry2.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktConstructorCalleeExpression != null ? ktConstructorCalleeExpression.getText() : null), (Object)"Suppress") ^ true) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)annotationEntry2), (BodyResolveMode)BodyResolveMode.PARTIAL);
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry2);
                if (annotationDescriptor == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)annotationDescriptor, (String)"context[BindingContext.A\u2026nnotationEntry] ?: return");
                AnnotationDescriptor descriptor2 = annotationDescriptor;
                if (Intrinsics.areEqual((Object)descriptor2.getFqName(), (Object)StandardNames.FqNames.suppress) ^ true) {
                    return;
                }
                for (ValueArgument argument2 : annotationEntry2.getValueArguments()) {
                    DiagnosticFactoryWithPsiElement newDiagnosticFactory;
                    KtStringTemplateExpression expression2;
                    String text2;
                    KtExpression ktExpression = argument2.getArgumentExpression();
                    if (!(ktExpression instanceof KtStringTemplateExpression)) {
                        ktExpression = null;
                    }
                    if ((KtStringTemplateExpression)ktExpression == null) {
                        continue;
                    }
                    String string = text2 = expression2.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    Character c = StringsKt.firstOrNull((CharSequence)string);
                    if (c == null || c.charValue() != '\"') continue;
                    Character c2 = StringsKt.lastOrNull((CharSequence)text2);
                    if (c2 == null || c2.charValue() != '\"') continue;
                    if ((DiagnosticFactoryWithPsiElement)MigrateDiagnosticSuppressionInspection.access$getMIGRATION_MAP$cp().get(StringUtil.unquoteString((String)text2)) == null) {
                        continue;
                    }
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("diagnostic.name.should.be.replaced.by.the.new.one", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceDiagnosticNameFix((DiagnosticFactory)newDiagnosticFactory)});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        MIGRATION_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"HEADER_DECLARATION_WITH_BODY", (Object)Errors.EXPECTED_DECLARATION_WITH_BODY), TuplesKt.to((Object)"HEADER_CLASS_CONSTRUCTOR_DELEGATION_CALL", (Object)Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL), TuplesKt.to((Object)"HEADER_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER", (Object)Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER), TuplesKt.to((Object)"HEADER_ENUM_CONSTRUCTOR", (Object)Errors.EXPECTED_ENUM_CONSTRUCTOR), TuplesKt.to((Object)"HEADER_ENUM_ENTRY_WITH_BODY", (Object)Errors.EXPECTED_ENUM_ENTRY_WITH_BODY), TuplesKt.to((Object)"HEADER_PROPERTY_INITIALIZER", (Object)Errors.EXPECTED_PROPERTY_INITIALIZER), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_NOT_TO_CLASS", (Object)Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE", (Object)Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE", (Object)Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION", (Object)Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION), TuplesKt.to((Object)"HEADER_WITHOUT_IMPLEMENTATION", (Object)Errors.NO_ACTUAL_FOR_EXPECT), TuplesKt.to((Object)"IMPLEMENTATION_WITHOUT_HEADER", (Object)Errors.ACTUAL_WITHOUT_EXPECT), TuplesKt.to((Object)"HEADER_CLASS_MEMBERS_ARE_NOT_IMPLEMENTED", (Object)Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS), TuplesKt.to((Object)"IMPL_MISSING", (Object)Errors.ACTUAL_MISSING)});
    }

    public static final /* synthetic */ Map access$getMIGRATION_MAP$cp() {
        return MIGRATION_MAP;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MigrateDiagnosticSuppressionInspection$ReplaceDiagnosticNameFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    public static final class ReplaceDiagnosticNameFix
    implements LocalQuickFix {
        private final DiagnosticFactory<?> diagnosticFactory;

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.getFamilyName();
            String string = this.diagnosticFactory.getName();
            Intrinsics.checkNotNull((Object)string);
            objectArray[1] = string;
            return KotlinBundle.message("replace.diagnostic.name.fix.text", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("replace.diagnostic.name.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtStringTemplateExpression)) {
                psiElement2 = null;
            }
            KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)psiElement2;
            if (ktStringTemplateExpression == null) {
                return;
            }
            KtStringTemplateExpression expression2 = ktStringTemplateExpression;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)expression2)) {
                return;
            }
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)expression2), (boolean)false, (int)2, null);
            expression2.replace((PsiElement)psiFactory.createExpression('\"' + this.diagnosticFactory.getName() + '\"'));
        }

        public ReplaceDiagnosticNameFix(@NotNull DiagnosticFactory<?> diagnosticFactory) {
            Intrinsics.checkNotNullParameter(diagnosticFactory, (String)"diagnosticFactory");
            this.diagnosticFactory = diagnosticFactory;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u00a5\u0001\u0010\u0003\u001a\u0098\u0001\u0012\u0004\u0012\u00020\u0005\u0012\u008d\u0001\u0012\u008a\u0001\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t \b*D\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MigrateDiagnosticSuppressionInspection$Companion;", "", "()V", "MIGRATION_MAP", "", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/diagnostics/AbstractDiagnostic;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

