/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.EmptyClipboardOwner;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.OutdatedBundledCompilerNotificationKt;
import org.jetbrains.kotlin.idea.configuration.ProjectUtilsKt;
import org.jetbrains.kotlin.idea.util.VersioningKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u000f\u001a\u00020\b2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n2\b\b\u0002\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/CopyKotlinProjectOverviewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getIDEVersion", "", "getKotlinStateInModules", "Lkotlin/sequences/Sequence;", "project", "Lcom/intellij/openapi/project/Project;", "getModuleBuildSystems", "getModuleBuildVersions", "prepareInfo", "infoSequence", "noValue", "update", "kotlin.idea"})
public final class CopyKotlinProjectOverviewAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.getData(CommonDataKeys.PROJECT) ?: return");
        Project project3 = project2;
        try {
            String result2 = StringsKt.trimIndent((String)("\n                " + this.getIDEVersion() + "\n                " + KotlinPluginUtil.getPluginVersion() + "\n                Kotlin Presence: " + this.prepareInfo(this.getKotlinStateInModules(project3), "Absent") + "\n                Build: " + CopyKotlinProjectOverviewAction.prepareInfo$default(this, this.getModuleBuildSystems(project3), null, 2, null) + "\n                Build Versions: " + this.prepareInfo(this.getModuleBuildVersions(project3), "Unknown") + "\n            "));
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
            Clipboard clipboard = toolkit.getSystemClipboard();
            clipboard.setContents(new StringSelection(result2), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
        catch (IndexNotReadyException _) {
            DumbService.getInstance((Project)project3).showDumbModeNotification(KotlinBundle.message("can.t.finish.while.indexing.is.in.progress", new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        presentation.setVisible(application.isInternal());
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(project2 != null);
    }

    private final String getIDEVersion() {
        String string;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        if (applicationInfoEx == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationInfoImpl");
        }
        ApplicationInfoImpl appInfo = (ApplicationInfoImpl)applicationInfoEx;
        String appName = appInfo.getFullApplicationName();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String edition = applicationNamesInfo.getEditionName();
        if (edition != null) {
            string = appName + " (" + edition + ')';
        } else {
            String string2 = appName;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appName");
        }
        return string;
    }

    private final String prepareInfo(Sequence<String> infoSequence, String noValue) {
        int size = 10;
        List infos = SequencesKt.toList((Sequence)SequencesKt.take(infoSequence, (int)(size + 1)));
        int n = infos.size();
        boolean bl = false;
        List infosSet = CollectionsKt.filterNotNull((Iterable)CollectionsKt.toSet((Iterable)infos.subList(0, Math.min(n, size))));
        String values = infosSet.isEmpty() ? noValue : CollectionsKt.joinToString$default((Iterable)infosSet, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return values + (infos.size() > size ? ", ..." : "");
    }

    static /* synthetic */ String prepareInfo$default(CopyKotlinProjectOverviewAction copyKotlinProjectOverviewAction, Sequence sequence, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "NO VALUE";
        }
        return copyKotlinProjectOverviewAction.prepareInfo((Sequence<String>)sequence, string);
    }

    private final Sequence<String> getKotlinStateInModules(Project project2) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules = moduleManager.getModules();
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(modules, null){
            private /* synthetic */ Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ Module[] $modules;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var5_4 = this.$modules;
                        var6_5 = var5_4.length;
                        var4_6 = 0;
lbl9:
                        // 2 sources

                        while (var4_6 < var6_5) {
                            module = var5_4[var4_6];
                            v0 = module;
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"module");
                            this.L$0 = $this$sequence;
                            this.L$1 = var5_4;
                            this.I$0 = var4_6;
                            this.I$1 = var6_5;
                            this.label = 1;
                            v1 = $this$sequence.yield((Object)(ProjectUtilsKt.hasKotlinFilesInSources(v0) != false ? "In Sources" : (ProjectUtilsKt.hasKotlinFilesOnlyInTests(module) != false ? "In Tests" : null)), (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl31
                        }
                        break;
                    }
                    case 1: {
                        var6_5 = this.I$1;
                        var4_6 = this.I$0;
                        var5_4 = (Module[])this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl31:
                        // 2 sources

                        ++var4_6;
                        ** GOTO lbl9
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$modules = moduleArray;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Sequence<String> getModuleBuildSystems(Project project2) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules = moduleManager.getModules();
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(modules, null){
            private /* synthetic */ Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ Module[] $modules;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var5_4 = this.$modules;
                        var6_5 = var5_4.length;
                        var4_6 = 0;
lbl9:
                        // 2 sources

                        while (var4_6 < var6_5) {
                            v0 = module = var5_4[var4_6];
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"module");
                            this.L$0 = $this$sequence;
                            this.L$1 = var5_4;
                            this.I$0 = var4_6;
                            this.I$1 = var6_5;
                            this.label = 1;
                            v1 = $this$sequence.yield((Object)BuildSystemTypeKt.getBuildSystemType((Module)v0).getClass().getSimpleName(), (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl29
                        }
                        break;
                    }
                    case 1: {
                        var6_5 = this.I$1;
                        var4_6 = this.I$0;
                        var5_4 = (Module[])this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        ++var4_6;
                        ** GOTO lbl9
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$modules = moduleArray;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Sequence<String> getModuleBuildVersions(Project project2) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules = moduleManager.getModules();
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(modules, null){
            private /* synthetic */ Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ Module[] $modules;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var5_4 = this.$modules;
                        var6_5 = var5_4.length;
                        var4_6 = 0;
lbl9:
                        // 2 sources

                        while (var4_6 < var6_5) {
                            v0 = module = var5_4[var4_6];
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"module");
                            compilerVersion = Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType((Module)v0), (Object)BuildSystemType.JPS.INSTANCE) != false ? VersioningKt.getBuildNumber() : OutdatedBundledCompilerNotificationKt.getExternalCompilerVersion(module);
                            this.L$0 = $this$sequence;
                            this.L$1 = var5_4;
                            this.I$0 = var4_6;
                            this.I$1 = var6_5;
                            this.label = 1;
                            v1 = $this$sequence.yield((Object)compilerVersion, (Continuation)this);
                            if (v1 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl30
                        }
                        break;
                    }
                    case 1: {
                        var6_5 = this.I$1;
                        var4_6 = this.I$0;
                        var5_4 = (Module[])this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl30:
                        // 2 sources

                        ++var4_6;
                        ** GOTO lbl9
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$modules = moduleArray;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

