/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.util.ui.tree.TreeModelListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTreeModel
implements Disposable,
TreeModel {
    protected final TreeModelListenerList listeners = new TreeModelListenerList();
    protected volatile boolean disposed;

    public void dispose() {
        this.disposed = true;
        this.listeners.clear();
    }

    protected void treeStructureChanged(TreePath path, int[] indices, Object[] children) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeStructureChanged(new TreeModelEvent((Object)this, path, indices, children));
        }
    }

    protected void treeNodesChanged(TreePath path, int[] indices, Object[] children) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeNodesChanged(new TreeModelEvent((Object)this, path, indices, children));
        }
    }

    protected void treeNodesInserted(TreePath path, int[] indices, Object[] children) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeNodesInserted(new TreeModelEvent((Object)this, path, indices, children));
        }
    }

    protected void treeNodesRemoved(TreePath path, int[] indices, Object[] children) {
        if (!this.listeners.isEmpty()) {
            this.listeners.treeNodesRemoved(new TreeModelEvent((Object)this, path, indices, children));
        }
    }

    @Override
    public void addTreeModelListener(@NotNull TreeModelListener listener) {
        if (!this.disposed) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTreeModelListener(@NotNull TreeModelListener listener) {
        if (!this.disposed) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
        throw new UnsupportedOperationException("editable tree have to implement TreeModel#valueForPathChanged");
    }
}

