/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageUtil {
    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        if (StartupUiUtil.isJreHiDPI()) {
            return RetinaImage.create(width, height, type);
        }
        return new BufferedImage(width, height, type);
    }

    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, int width, int height, int type) {
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            return RetinaImage.create(gc, width, height, type);
        }
        return new BufferedImage(width, height, type);
    }

    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        return ImageUtil.createImage(g, width, height, type, PaintUtil.RoundingMode.FLOOR);
    }

    @NotNull
    public static BufferedImage createImage(Graphics g, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (JreHiDpiUtil.isJreHiDPI(g2d)) {
                return RetinaImage.create(g2d, width, height, type, rm);
            }
            return new BufferedImage(rm.round(width), rm.round(height), type);
        }
        return ImageUtil.createImage(rm.round(width), rm.round(height), type);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        return ImageUtil.toBufferedImage(image, false);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize) {
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jbImage = (JBHiDPIScaledImage)image;
            Image delegate = jbImage.getDelegate();
            if (delegate != null) {
                image = delegate;
            }
            if (inUserSize) {
                image = ImageUtil.scaleImage(image, 1.0 / jbImage.getScale());
            }
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        final int width = image.getWidth(null);
        final int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            return new BufferedImage(Math.max(width, 1), Math.max(height, 1), 2){

                @Override
                public int getWidth() {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight() {
                    return Math.max(height, 0);
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return Math.max(height, 0);
                }
            };
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static double getImageScale(Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getScale();
        }
        return 1.0;
    }

    public static int getRealWidth(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getWidth(null);
    }

    public static int getRealHeight(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getHeight(null);
    }

    public static int getUserWidth(@NotNull Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserWidth(null);
        }
        return image.getWidth(null);
    }

    public static int getUserHeight(@NotNull Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserHeight(null);
        }
        return image.getHeight(null);
    }

    public static Image filter(Image image, ImageFilter filter) {
        if (image == null || filter == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter));
    }

    public static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(image, scale);
    }

    public static Image scaleImage(Image image, int width, int height) {
        if (width <= 0 || height <= 0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(width, height);
        }
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull ScaleContext ctx) {
        if (image == null) {
            return null;
        }
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            return RetinaImage.createFrom(image, ctx.getScale(ScaleType.SYS_SCALE), null);
        }
        return image;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull JBUI.ScaleContext ctx) {
        return ImageUtil.ensureHiDPI(image, (ScaleContext)ctx);
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull ScaleContext ctx, double userWidth, double userHeight) {
        if (image == null) {
            return null;
        }
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            return new JBHiDPIScaledImage(image, userWidth, userHeight, 2);
        }
        return image;
    }
}

