/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.AATextInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphicsUtil {
    private static final MethodInvocator ourSafelyGetGraphicsMethod = new MethodInvocator(JComponent.class, "safelyGetGraphics", new Class[]{Component.class});
    private static final Graphics2D ourGraphics = new BufferedImage(1, 1, 2).createGraphics();

    public static void applyRenderingHints(@NotNull Graphics2D g) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            g.addRenderingHints(map);
        }
    }

    public static void setupFractionalMetrics(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static void setupAntialiasing(@NotNull Graphics g2) {
        GraphicsUtil.setupAntialiasing(g2, true, false);
    }

    public static int stringWidth(@NotNull String text, Font font) {
        GraphicsUtil.setupAntialiasing(ourGraphics, true, true);
        return ourGraphics.getFontMetrics(font).stringWidth(text);
    }

    public static int charWidth(char ch, Font font) {
        return ourGraphics.getFontMetrics(font).charWidth(ch);
    }

    public static int charWidth(int ch, Font font) {
        return ourGraphics.getFontMetrics(font).charWidth(ch);
    }

    public static void setupAntialiasing(Graphics g2, boolean enableAA, boolean ignoreSystemSettings) {
        if (g2 instanceof Graphics2D) {
            Graphics2D g = (Graphics2D)g2;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map != null && !ignoreSystemSettings) {
                g.addRenderingHints(map);
            } else {
                Object hint = enableAA ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
            }
        }
    }

    public static GraphicsConfig setupRoundedBorderAntialiasing(Graphics g) {
        return new GraphicsConfig(g).setupRoundedBorderAntialiasing();
    }

    public static GraphicsConfig setupAAPainting(Graphics g) {
        return new GraphicsConfig(g).setupAAPainting();
    }

    public static GraphicsConfig disableAAPainting(Graphics g) {
        return new GraphicsConfig(g).disableAAPainting();
    }

    public static GraphicsConfig paintWithAlpha(Graphics g, float alpha) {
        return new GraphicsConfig(g).paintWithAlpha(alpha);
    }

    public static Graphics safelyGetGraphics(Component c) {
        return ourSafelyGetGraphicsMethod.isAvailable() ? (Graphics)ourSafelyGetGraphicsMethod.invoke(null, new Object[]{c}) : c.getGraphics();
    }

    public static Object getAntialiasingType(@NotNull JComponent component) {
        return AATextInfo.getClientProperty(component);
    }

    public static void setAntialiasingType(@NotNull JComponent component, @Nullable Object type) {
        AATextInfo.putClientProperty(type, component);
    }

    public static Object createAATextInfo(@NotNull Object hint) {
        return AATextInfo.create(hint, UIUtil.getLcdContrastValue());
    }

    static {
        GraphicsUtil.setupFractionalMetrics(ourGraphics);
        GraphicsUtil.setupAntialiasing(ourGraphics, true, true);
    }
}

