/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result = ourInstance.get();
        if (result == null && !ourInstance.compareAndSet(null, result = new SwingEdtInvocationManager())) {
            result = ourInstance.get();
        }
        return result;
    }

    @Nullable
    public static EdtInvocationManager setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        return ourInstance.getAndSet(edtInvocationManager);
    }

    @ApiStatus.Internal
    public static void restoreEdtInvocationManager(@NotNull EdtInvocationManager current, @Nullable EdtInvocationManager old) {
        ourInstance.compareAndSet(current, old);
    }

    public void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (this.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                this.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance(EdtInvocationManager.class).error((Throwable)e);
            }
        }
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public boolean isEventDispatchThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            EventQueue.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            EventQueue.invokeAndWait(task);
        }
    }
}

