/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoaderCacheIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SVGLoaderCache {
    private static final long MAX_IMAGE_SIZE = 0x1000000L;

    @NotNull
    protected abstract Path getCachesHome();

    protected abstract void forkIOTask(@NotNull Runnable var1);

    @NotNull
    private Path cacheFile(byte @NotNull [] theme, byte @NotNull [] imageBytes, double scale) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256");
            d.update(theme);
            d.update(imageBytes);
            String hex = StringUtil.toHexString((byte[])d.digest());
            return this.getCachesHome().resolve(hex + ".x" + scale);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1 is not supported!", e);
        }
    }

    @Nullable
    public final BufferedImage loadFromCache(byte @NotNull [] theme, byte @NotNull [] imageBytes, double scale, @NotNull ImageLoader.Dimension2DDouble docSize) {
        Path file = this.cacheFile(theme, imageBytes, scale);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try {
            long size = Files.size(file);
            if (size > 0x1000000L) {
                this.forkIOTask(() -> {
                    try {
                        FileUtil.delete((Path)file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
            byte[] bytes = Files.readAllBytes(file);
            BufferedImage image = SVGLoaderCacheIO.readImageFile(bytes, docSize);
            IconLoadMeasurer.svgCacheRead.addDurationStartedAt(start);
            return image;
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn("Failed to read SVG cache from: " + file + ". " + e.getMessage(), (Throwable)e);
            this.forkIOTask(() -> {
                try {
                    FileUtil.delete((Path)file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return null;
        }
    }

    public final void storeLoadedImage(byte @NotNull [] theme, byte @NotNull [] imageBytes, double scale, @NotNull BufferedImage image, @NotNull ImageLoader.Dimension2DDouble size) {
        if (image.getType() != 2) {
            Logger.getInstance(this.getClass()).warn("Unsupported image type for SVGLoader cache: " + image.getType());
            return;
        }
        this.forkIOTask(() -> {
            long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
            Path file = this.cacheFile(theme, imageBytes, scale);
            try {
                SVGLoaderCacheIO.writeImageFile(file, image, size);
            }
            catch (Exception e) {
                Logger.getInstance(SVGLoaderCache.class).warn("Failed to write SVG cache to: " + file + ". " + e.getMessage(), (Throwable)e);
            }
            IconLoadMeasurer.svgCacheWrite.addDurationStartedAt(start);
        });
    }
}

