/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.MyTranscoder;
import com.intellij.ui.svg.SaxSvgDocumentFactory;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoaderCache;
import com.intellij.util.SVGLoaderPrebuilt;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SVGLoader {
    private static final byte[] DEFAULT_THEME = new byte[0];
    private static SvgElementColorPatcherProvider ourColorPatcher = null;
    private static final SVGLoaderCache ourCache = new SVGLoaderCache(){

        @Override
        @NotNull
        protected Path getCachesHome() {
            return Paths.get(PathManager.getSystemPath(), "icons");
        }

        @Override
        protected void forkIOTask(@NotNull Runnable action) {
            AppExecutorUtil.getAppExecutorService().execute(action);
        }
    };
    public static final int ICON_DEFAULT_SIZE = 16;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        return SVGLoader.load(url, stream, scale, null);
    }

    @ApiStatus.Internal
    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale, @Nullable ImageLoader.Dimension2DDouble docSize) throws IOException {
        BufferedImage image;
        if (docSize == null) {
            docSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
        }
        byte[] theme = null;
        byte[] svgBytes = null;
        if (SystemProperties.getBooleanProperty((String)"idea.ui.icons.svg.disk.cache", (boolean)true)) {
            SvgElementColorPatcher subPatcher;
            theme = DEFAULT_THEME;
            SvgElementColorPatcherProvider colorPatcher = ourColorPatcher;
            if (colorPatcher != null && (subPatcher = colorPatcher.forURL(url)) != null) {
                theme = subPatcher.digest();
            }
            if (theme == DEFAULT_THEME && (image = SVGLoaderPrebuilt.loadUrlFromPreBuiltCache(url, scale, docSize)) != null) {
                return image;
            }
            if (theme != null) {
                svgBytes = FileUtil.loadBytes((InputStream)stream);
                image = ourCache.loadFromCache(theme, svgBytes, scale, docSize);
                if (image != null) {
                    return image;
                }
                stream = new ByteArrayInputStream(svgBytes);
            }
        }
        if ((image = SVGLoader.loadWithoutCache(url, stream, scale, docSize)) != null && theme != null) {
            ourCache.storeLoadedImage(theme, svgBytes, scale, image, docSize);
        }
        return image;
    }

    @ApiStatus.Internal
    public static BufferedImage loadWithoutCache(@Nullable URL url, @NotNull InputStream stream, double scale, @Nullable ImageLoader.Dimension2DDouble docSize) throws IOException {
        try {
            MyTranscoder transcoder = MyTranscoder.createImage(scale, SVGLoader.createTranscodeInput(url, stream));
            if (docSize != null) {
                docSize.setSize(transcoder.getOrigDocWidth(), transcoder.getOrigDocHeight());
            }
            return transcoder.getImage();
        }
        catch (TranscoderException ex) {
            if (docSize != null) {
                docSize.setSize(0.0, 0.0);
            }
            throw new IOException(ex);
        }
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext ctx, double width, double height) throws IOException {
        try {
            double s = ctx.getScale(DerivedScaleType.PIX_SCALE);
            return MyTranscoder.createImage(1.0, SVGLoader.createTranscodeInput(url, stream), (float)(width * s), (float)(height * s)).getImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext ctx, double width, double height) throws IOException {
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx, width, height);
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, ctx);
        return (T)t;
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, ScaleContext ctx) throws IOException {
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx.getScale(DerivedScaleType.PIX_SCALE));
        BufferedImage t = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, ctx);
        return (T)t;
    }

    @Deprecated
    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx) throws IOException {
        return SVGLoader.loadHiDPI(url, stream, (ScaleContext)ctx);
    }

    public static ImageLoader.Dimension2DDouble getDocumentSize(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        int ch;
        BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream(100);
        byte[] bytes = new byte[3];
        boolean checkClosingBracket = false;
        while ((ch = stream.read()) != -1) {
            buffer.write(ch);
            if (ch == 60) {
                int n = stream.read(bytes, 0, 3);
                if (n == -1) break;
                buffer.write(bytes, 0, n);
                checkClosingBracket = n == 3 && bytes[0] == 115 && bytes[1] == 118 && bytes[2] == 103;
                continue;
            }
            if (!checkClosingBracket || ch != 62) continue;
            buffer.write(new byte[]{60, 47, 115, 118, 103, 62});
            return SVGLoader.getDocumentSize(scale, SVGLoader.createTranscodeInput(url, new ByteArrayInputStream(buffer.getInternalBuffer(), 0, buffer.size())));
        }
        return new ImageLoader.Dimension2DDouble(16.0 * scale, 16.0 * scale);
    }

    public static double getMaxZoomFactor(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext ctx) throws IOException {
        ImageLoader.Dimension2DDouble size = SVGLoader.getDocumentSize(ctx.getScale(DerivedScaleType.PIX_SCALE), SVGLoader.createTranscodeInput(url, stream));
        double iconMaxSize2 = MyTranscoder.getIconMaxSize();
        return Math.min(iconMaxSize2 / size.getWidth(), iconMaxSize2 / size.getHeight());
    }

    private SVGLoader() {
    }

    @NotNull
    private static TranscoderInput createTranscodeInput(@Nullable URL url, @NotNull InputStream stream) throws IOException {
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol())) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new SaxSvgDocumentFactory().createDocument(uri, stream);
        SVGLoader.patchColors(url, document);
        TranscoderInput myTranscoderInput = new TranscoderInput(document);
        return myTranscoderInput;
    }

    private static void patchColors(@Nullable URL url, @NotNull Document document) {
        SvgElementColorPatcher patcher;
        SvgElementColorPatcherProvider colorPatcher = ourColorPatcher;
        if (colorPatcher != null && (patcher = colorPatcher.forURL(url)) != null) {
            patcher.patchColors(document.getDocumentElement());
        }
    }

    @Deprecated
    public static void setColorPatcher(final @Nullable SvgColorPatcher colorPatcher) {
        if (colorPatcher == null) {
            SVGLoader.setColorPatcherProvider(null);
            return;
        }
        SVGLoader.setColorPatcherProvider(new SvgElementColorPatcherProvider(){

            @Override
            public SvgElementColorPatcher forURL(final @Nullable URL url) {
                return new SvgElementColorPatcher(){

                    @Override
                    public void patchColors(@NotNull Element svg) {
                        colorPatcher.patchColors(url, svg);
                    }

                    @Override
                    public byte @Nullable [] digest() {
                        return null;
                    }
                };
            }
        });
    }

    public static void setColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        ourColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    private static ImageLoader.Dimension2DDouble getDocumentSize(double scale, @NotNull TranscoderInput input) {
        Document document = input.getDocument();
        BridgeContext ctx = new MyTranscoder(scale).createBridgeContext((SVGOMDocument)document);
        new GVTBuilder().build(ctx, document);
        Dimension2D size = ctx.getDocumentSize();
        return new ImageLoader.Dimension2DDouble(size.getWidth() * scale, size.getHeight() * scale);
    }

    @Deprecated
    public static interface SvgColorPatcher {
        @Deprecated
        default public void patchColors(@NotNull Element svg) {
        }

        default public void patchColors(@Nullable URL url, @NotNull Element svg) {
            this.patchColors(svg);
        }
    }

    public static interface SvgElementColorPatcherProvider {
        @Nullable
        public SvgElementColorPatcher forURL(@Nullable URL var1);
    }

    public static interface SvgElementColorPatcher {
        public void patchColors(@NotNull Element var1);

        public byte @Nullable [] digest();
    }
}

