/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.ui.scale.ScaleType;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;

public final class Scale {
    final double value;
    final ScaleType type;
    private static final ThreadLocal<EnumMap<ScaleType, Double2ObjectOpenHashMap<Scale>>> cache = ThreadLocal.withInitial(() -> new EnumMap(ScaleType.class));

    @NotNull
    public static Scale create(double value, @NotNull ScaleType type) {
        Scale scale;
        EnumMap<ScaleType, Double2ObjectOpenHashMap<Scale>> enumMap = cache.get();
        Double2ObjectOpenHashMap map = enumMap.get((Object)type);
        if (map == null) {
            map = new Double2ObjectOpenHashMap();
            enumMap.put(type, (Double2ObjectOpenHashMap<Scale>)map);
        }
        if ((scale = (Scale)map.get(value)) != null) {
            return scale;
        }
        scale = new Scale(value, type);
        map.put(value, (Object)scale);
        return scale;
    }

    private Scale(double value, @NotNull ScaleType type) {
        this.value = value;
        this.type = type;
    }

    public double value() {
        return this.value;
    }

    @NotNull
    public ScaleType type() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return "[" + this.type.name() + " " + this.value + "]";
    }
}

