/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.paint.RegionPainter2D;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RectanglePainter2D implements RegionPainter2D<Double>
{
    DRAW{

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height, @Nullable Double arc) {
            this.paint(g, x, y, width, height, arc, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height) {
            this.paint(g, x, y, width, height, null, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics2D g, @NotNull Rectangle2D rect, @Nullable Double arc, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth, @NotNull Object valueAA) {
            this.paint(g, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), arc, strokeType, strokeWidth, valueAA);
        }

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth) {
            this.paint(g, x, y, width, height, null, strokeType, strokeWidth, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height, @Nullable Double arc, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth, @NotNull Object valueAA) {
            if (width < 0.0 || height < 0.0) {
                return;
            }
            double sw = PaintUtil.alignToInt(strokeWidth, g);
            double dsw = sw * 2.0;
            if (width > dsw && height > dsw) {
                x = PaintUtil.alignToInt(x, g);
                y = PaintUtil.alignToInt(y, g);
                double[] strokeSplit = LinePainter2D.getStrokeSplit(ScaleContext.create(g), strokeType, sw, false);
                double sw_1 = strokeSplit[0];
                double sw_2 = strokeSplit[1];
                double a_out = strokeType == LinePainter2D.StrokeType.CENTERED ? sw : (strokeType == LinePainter2D.StrokeType.OUTSIDE ? dsw : 0.0);
                double x_out = x - sw_1;
                double y_out = y - sw_1;
                double w_out = sw_1 + width + sw_2;
                double h_out = sw_1 + height + sw_2;
                Path2D.Double path = new Path2D.Double(0);
                if (arc != null) {
                    path.append(new RoundRectangle2D.Double(x_out, y_out, w_out, h_out, arc + a_out, arc + a_out), false);
                    path.append(new RoundRectangle2D.Double(x_out + sw, y_out + sw, w_out - dsw, h_out - dsw, arc - dsw, arc - dsw), false);
                } else {
                    path.append(new Rectangle2D.Double(x_out, y_out, w_out, h_out), false);
                    path.append(new Rectangle2D.Double(x_out + sw, y_out + sw, w_out - dsw, h_out - dsw), false);
                }
                PaintUtil.paintWithAA(g, arc != null ? valueAA : RenderingHints.VALUE_ANTIALIAS_DEFAULT, () -> g.fill(path));
            } else {
                FILL.paint(g, x, y, width, height, arc, strokeType, strokeWidth, valueAA);
            }
        }
    }
    ,
    FILL{

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height, @Nullable Double arc) {
            this.paint(g, x, y, width, height, arc, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height) {
            this.paint(g, x, y, width, height, null, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics2D g, @NotNull Rectangle2D rect, @Nullable Double arc, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth, @NotNull Object valueAA) {
            this.paint(g, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), arc, strokeType, strokeWidth, valueAA);
        }

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth) {
            this.paint(g, x, y, width, height, null, strokeType, strokeWidth, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        @Override
        public void paint(@NotNull Graphics2D g, double x, double y, double width, double height, @Nullable Double arc, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth, @NotNull Object valueAA) {
            if (width < 0.0 || height < 0.0) {
                return;
            }
            double sw = PaintUtil.alignToInt(strokeWidth, g);
            x = PaintUtil.alignToInt(x, g);
            y = PaintUtil.alignToInt(y, g);
            double[] strokeSplit = LinePainter2D.getStrokeSplit(ScaleContext.create(g), strokeType, sw, false);
            double sw_1 = strokeSplit[0];
            double sw_2 = strokeSplit[1];
            double dsw = sw * 2.0;
            if (strokeType == LinePainter2D.StrokeType.INSIDE) {
                dsw = 0.0;
            }
            double x_out = x - sw_1;
            double y_out = y - sw_1;
            double w_out = sw_1 + width + sw_2;
            double h_out = sw_1 + height + sw_2;
            RectangularShape rect = arc != null ? new RoundRectangle2D.Double(x_out, y_out, w_out, h_out, arc + dsw, arc + dsw) : new Rectangle2D.Double(x_out, y_out, w_out, h_out);
            PaintUtil.paintWithAA(g, arc != null ? valueAA : RenderingHints.VALUE_ANTIALIAS_DEFAULT, () -> g.fill(rect));
        }
    };


    @NotNull
    public static Rectangle2D align(@NotNull Graphics2D g, @NotNull EnumSet<LinePainter2D.Align> align, double x, double y, double prefWidth, double prefHeight, @NotNull LinePainter2D.StrokeType strokeType, double strokeWidth) {
        double[] p;
        if (align.contains((Object)LinePainter2D.Align.CENTER_X) && prefWidth >= strokeWidth * 2.0) {
            p = LinePainter2D.alignSizeXY(g, x, prefWidth, strokeType, strokeWidth, true);
            x = p[0];
            prefWidth = p[1];
        }
        if (align.contains((Object)LinePainter2D.Align.CENTER_Y) && prefHeight >= strokeWidth * 2.0) {
            p = LinePainter2D.alignSizeXY(g, y, prefHeight, strokeType, strokeWidth, true);
            y = p[0];
            prefHeight = p[1];
        }
        return new Rectangle2D.Double(x, y, prefWidth, prefHeight);
    }

    public abstract void paint(@NotNull Graphics2D var1, double var2, double var4, double var6, double var8, @Nullable Double var10, @NotNull LinePainter2D.StrokeType var11, double var12, @NotNull Object var14);

    public abstract void paint(@NotNull Graphics2D var1, double var2, double var4, double var6, double var8, @NotNull LinePainter2D.StrokeType var10, double var11);

    public abstract void paint(@NotNull Graphics2D var1, double var2, double var4, double var6, double var8);

    public abstract void paint(@NotNull Graphics2D var1, @NotNull Rectangle2D var2, @Nullable Double var3, @NotNull LinePainter2D.StrokeType var4, double var5, @NotNull Object var7);
}

