/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaintUtil {
    public static ParityMode getParityMode(double usrValue, @NotNull Graphics2D g) {
        return PaintUtil.getParityMode(usrValue, ScaleContext.create(g), null);
    }

    public static ParityMode getParityMode(double usrValue, @NotNull ScaleContext ctx, @Nullable RoundingMode rm) {
        int devValue = PaintUtil.devValue(usrValue, PaintUtil.getScale(ctx), rm == null ? RoundingMode.ROUND : rm);
        return ParityMode.of(devValue);
    }

    public static double alignToInt(double usrValue, @NotNull Graphics2D g) {
        return PaintUtil.alignToInt(usrValue, ScaleContext.create(g), null, null);
    }

    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable RoundingMode rm) {
        return PaintUtil.alignToInt(usrValue, ScaleContext.create(g), rm, null);
    }

    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable ParityMode pm) {
        return PaintUtil.alignToInt(usrValue, ScaleContext.create(g), null, pm);
    }

    public static double alignToInt(double usrValue, @NotNull ScaleContext ctx, @Nullable RoundingMode rm, @Nullable ParityMode pm) {
        double scale;
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        if ((scale = PaintUtil.getScale(ctx)) == 0.0) {
            return 0.0;
        }
        int devValue = PaintUtil.devValue(usrValue, scale, pm != null && rm == RoundingMode.ROUND ? RoundingMode.FLOOR : rm);
        if (pm != null && ParityMode.of(devValue) != pm) {
            devValue += rm == RoundingMode.FLOOR ? -1 : 1;
        }
        return (double)devValue / scale;
    }

    public static double alignToInt(double usrValue, @NotNull ScaleContext ctx) {
        return PaintUtil.alignToInt(usrValue, ctx, null, null);
    }

    public static double devValue(double usrValue, @NotNull Graphics2D g) {
        return PaintUtil.devValue(usrValue, ScaleContext.create(g));
    }

    public static double devValue(double usrValue, @NotNull ScaleContext ctx) {
        return usrValue * PaintUtil.getScale(ctx);
    }

    private static int devValue(double usrValue, double scale, @Nullable RoundingMode rm) {
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        return rm.round(usrValue * scale);
    }

    public static double devPixel(Graphics2D g) {
        return 1.0 / PaintUtil.devValue(1.0, g);
    }

    private static double getScale(ScaleContext ctx) {
        double scale;
        double d = scale = ctx.getScale(ScaleType.USR_SCALE) == 0.0 ? 0.0 : ctx.getScale(DerivedScaleType.PIX_SCALE) / ctx.getScale(ScaleType.USR_SCALE);
        if (scale <= 0.0) {
            // empty if block
        }
        return scale;
    }

    @Nullable
    public static AffineTransform alignTxToInt(@NotNull Graphics2D g, @Nullable Point2D offset, boolean alignX, boolean alignY, RoundingMode rm) {
        try {
            AffineTransform tx = g.getTransform();
            if (PaintUtil.isFractionalScale(tx)) {
                double scaleX = tx.getScaleX();
                double scaleY = tx.getScaleY();
                AffineTransform alignedTx = new AffineTransform();
                double trX = tx.getTranslateX();
                double trY = tx.getTranslateY();
                if (alignX) {
                    double offX = trX + (offset != null ? offset.getX() * scaleX : 0.0);
                    trX += (double)rm.round(offX) - offX;
                }
                if (alignY) {
                    double offY = trY + (offset != null ? offset.getY() * scaleY : 0.0);
                    trY += (double)rm.round(offY) - offY;
                }
                alignedTx.translate(trX, trY);
                alignedTx.scale(scaleX, scaleY);
                assert (tx.getShearX() == 0.0 && tx.getShearY() == 0.0);
                g.setTransform(alignedTx);
                return tx;
            }
        }
        catch (Exception e) {
            Logger.getInstance((String)"#com.intellij.ui.paint.PaintUtil").error((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static Shape alignClipToInt(@NotNull Graphics2D g, boolean alignH, boolean alignV, RoundingMode xyRM, RoundingMode whRM) {
        Shape clip = g.getClip();
        if (clip instanceof Rectangle2D && PaintUtil.isFractionalScale(g.getTransform())) {
            Rectangle2D rect = (Rectangle2D)clip;
            double x = rect.getX();
            double y = rect.getY();
            double w = rect.getWidth();
            double h = rect.getHeight();
            if (alignH) {
                x = PaintUtil.alignToInt(rect.getX(), g, xyRM);
                w = PaintUtil.alignToInt(rect.getX() + rect.getWidth(), g, whRM) - x;
            }
            if (alignV) {
                y = PaintUtil.alignToInt(rect.getY(), g, xyRM);
                h = PaintUtil.alignToInt(rect.getY() + rect.getHeight(), g, whRM) - y;
            }
            g.setClip(new Rectangle2D.Double(x, y, w, h));
            return clip;
        }
        return null;
    }

    @NotNull
    public static Point2D getFractOffsetInRootPane(@NotNull JComponent comp) {
        if (!comp.isShowing() || !PaintUtil.isFractionalScale(comp.getGraphicsConfiguration().getDefaultTransform())) {
            return new Point2D.Double();
        }
        int x = 0;
        int y = 0;
        while (!(comp instanceof JRootPane) && comp != null) {
            x += comp.getX();
            y += comp.getY();
            comp = (JComponent)comp.getParent();
        }
        double scale = JBUIScale.sysScale(comp);
        double sx = (double)x * scale;
        double sy = (double)y * scale;
        return new Point2D.Double((sx - (double)((int)sx)) / scale, (sy - (double)((int)sy)) / scale);
    }

    @NotNull
    public static Point2D negate(@NotNull Point2D pt) {
        return new Point2D.Double(-pt.getX(), -pt.getY());
    }

    public static boolean isFractionalScale(@NotNull AffineTransform tx) {
        double scaleX = tx.getScaleX();
        double scaleY = tx.getScaleY();
        return scaleX != (double)((int)scaleX) || scaleY != (double)((int)scaleY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintWithAA(@NotNull Graphics2D g, @NotNull Object valueAA, @NotNull Runnable paint) {
        if (valueAA == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            paint.run();
            return;
        }
        Object key = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, valueAA);
        try {
            paint.run();
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, key);
        }
    }

    @NotNull
    public static Point2D insets2offset(@Nullable Insets in) {
        return in == null ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(in.left, in.top);
    }

    public static enum ParityMode {
        EVEN,
        ODD;


        public boolean even() {
            return this == EVEN;
        }

        public static ParityMode of(int value) {
            return value % 2 == 0 ? EVEN : ODD;
        }

        public static ParityMode invert(ParityMode pm) {
            return pm == EVEN ? ODD : EVEN;
        }
    }

    public static enum RoundingMode {
        FLOOR{

            @Override
            public int round(double value) {
                return (int)Math.floor(value);
            }
        }
        ,
        CEIL{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value);
            }
        }
        ,
        ROUND{

            @Override
            public int round(double value) {
                return (int)Math.round(value);
            }
        }
        ,
        ROUND_FLOOR_BIAS{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value - 0.5);
            }
        };


        public abstract int round(double var1);
    }
}

