/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public final class UiInterceptors {
    private static final Queue<UiInterceptor<?>> ourInterceptors = new ConcurrentLinkedQueue();

    public static boolean tryIntercept(@NotNull Object uiComponent) {
        UiInterceptor<?> interceptor = ourInterceptors.poll();
        if (interceptor == null) {
            return false;
        }
        interceptor.intercept(uiComponent);
        return true;
    }

    public static void register(@NotNull UiInterceptor<?> interceptor) {
        ourInterceptors.offer(interceptor);
    }

    public static void clear() {
        ArrayList interceptors = new ArrayList(ourInterceptors);
        ourInterceptors.clear();
        if (!interceptors.isEmpty()) {
            throw new IllegalStateException("Expected UI was not shown: " + interceptors);
        }
    }

    public static abstract class UiInterceptor<T> {
        @NotNull
        private final Class<T> myClass;

        protected UiInterceptor(@NotNull Class<T> componentClass) {
            this.myClass = componentClass;
        }

        public final void intercept(@NotNull Object component) {
            if (!this.myClass.isInstance(component)) {
                throw new IllegalStateException("Unexpected UI component appears: wanted " + this.myClass.getName() + "; got: " + component.getClass().getName() + " (" + component + ")");
            }
            this.doIntercept(this.myClass.cast(component));
        }

        protected abstract void doIntercept(@NotNull T var1);

        public String toString() {
            return this.myClass.getName() + " (interceptor: " + this.getClass().getName() + ")";
        }
    }
}

