/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Couple;
import com.intellij.util.NotNullProducer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class MixedColorProducer
implements NotNullProducer<Color> {
    private final Couple<Color> couple;
    private double mixer;
    private Color cached;
    private int argb0;
    private int argb1;

    public MixedColorProducer(@NotNull Color color0, @NotNull Color color1) {
        this.couple = Couple.of((Object)color0, (Object)color1);
    }

    public MixedColorProducer(@NotNull Color color0, @NotNull Color color1, double mixer) {
        this(color0, color1);
        this.setMixer(mixer);
    }

    public void setMixer(double value) {
        if (Double.isNaN(value) || value < 0.0 || 1.0 < value) {
            throw new IllegalArgumentException("mixer[0..1] is " + value);
        }
        if (this.mixer != value) {
            this.mixer = value;
            this.cached = null;
        }
    }

    private void updateFirstARGB() {
        int value = ((Color)this.couple.first).getRGB();
        if (this.argb0 != value) {
            this.argb0 = value;
            this.cached = null;
        }
    }

    private void updateSecondARGB() {
        int value = ((Color)this.couple.second).getRGB();
        if (this.argb1 != value) {
            this.argb1 = value;
            this.cached = null;
        }
    }

    private int mix(int pos) {
        int value0 = 0xFF & this.argb0 >> pos;
        int value1 = 0xFF & this.argb1 >> pos;
        if (value0 == value1) {
            return value0;
        }
        return value0 + (int)Math.round(this.mixer * (double)(value1 - value0));
    }

    @NotNull
    public Color produce(double mixer) {
        this.setMixer(mixer);
        return this.produce();
    }

    @NotNull
    public Color produce() {
        if (this.mixer <= 0.0) {
            return (Color)this.couple.first;
        }
        if (this.mixer >= 1.0) {
            return (Color)this.couple.second;
        }
        this.updateFirstARGB();
        this.updateSecondARGB();
        if (this.cached == null) {
            this.cached = new Color(this.mix(16), this.mix(8), this.mix(0), this.mix(24));
        }
        return this.cached;
    }
}

