/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.util.MathUtil;
import com.intellij.util.NotNullProducer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private ColorUtil() {
    }

    @NotNull
    public static Color marker(final @NotNull String name) {
        return new JBColor(() -> {
            throw new AssertionError((Object)name);
        }){

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public String toString() {
                return name;
            }
        };
    }

    @NotNull
    public static Color softer(@NotNull Color color) {
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
    }

    @NotNull
    public static Color darker(@NotNull Color color, int tones) {
        return ColorUtil.hackBrightness(color, tones, 0.9090909f);
    }

    @NotNull
    public static Color brighter(@NotNull Color color, int tones) {
        return ColorUtil.hackBrightness(color, tones, 1.1f);
    }

    @NotNull
    public static Color hackBrightness(@NotNull Color color, int howMuch, float hackValue) {
        return ColorUtil.hackBrightness(color.getRed(), color.getGreen(), color.getBlue(), howMuch, hackValue);
    }

    @NotNull
    public static Color hackBrightness(int r, int g, int b, int howMuch, float hackValue) {
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        float brightness = hsb[2];
        for (int i = 0; i < howMuch && (brightness = MathUtil.clamp((float)(brightness * hackValue), (float)0.0f, (float)1.0f)) != 0.0f && brightness != 1.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], hsb[1], brightness);
    }

    @NotNull
    public static Color saturate(@NotNull Color color, int tones) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.min(1.0f, saturation * 1.1f)) != 1.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], saturation, hsb[2]);
    }

    @NotNull
    public static Color desaturate(@NotNull Color color, int tones) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.max(0.0f, saturation / 1.1f)) != 0.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], saturation, hsb[2]);
    }

    @NotNull
    public static Color dimmer(@NotNull Color color) {
        return ColorUtil.wrap(color, (NotNullProducer<? extends Color>)((NotNullProducer)() -> {
            float[] rgb = color.getRGBColorComponents(null);
            float alpha = 0.8f;
            float rem = 1.0f - alpha;
            return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
        }));
    }

    private static Color wrap(@NotNull Color color, NotNullProducer<? extends Color> func) {
        return color instanceof JBColor ? new JBColor(func) : (Color)func.produce();
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : Math.max(n, 0);
    }

    @NotNull
    public static Color shift(@NotNull Color c, double d) {
        NotNullProducer func = () -> new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
        return ColorUtil.wrap(c, (NotNullProducer<? extends Color>)func);
    }

    @NotNull
    public static Color withAlpha(@NotNull Color c, double a) {
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    @NotNull
    public static Color withPreAlpha(@NotNull Color c, double a) {
        float[] rgba = new float[4];
        rgba = ColorUtil.withAlpha(c, a).getRGBComponents(rgba);
        return new Color(rgba[0] * rgba[3], rgba[1] * rgba[3], rgba[2] * rgba[3], 1.0f);
    }

    @NotNull
    public static Color toAlpha(@Nullable Color color, int a) {
        Color c = color == null ? Color.black : color;
        NotNullProducer func = () -> new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        return ColorUtil.wrap(c, (NotNullProducer<? extends Color>)func);
    }

    @NotNull
    public static String toHex(@NotNull Color c) {
        return ColorUtil.toHex(c, false);
    }

    @NotNull
    public static String toHex(@NotNull Color c, boolean withAlpha) {
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B = Integer.toHexString(c.getBlue());
        String rgbHex = (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B.length() < 2 ? "0" : "") + B;
        if (!withAlpha) {
            return rgbHex;
        }
        String A = Integer.toHexString(c.getAlpha());
        return rgbHex + (A.length() < 2 ? "0" : "") + A;
    }

    @NotNull
    public static String toHtmlColor(@NotNull Color c) {
        return "#" + ColorUtil.toHex(c);
    }

    @NotNull
    public static Color fromHex(@NotNull String str) {
        return ColorHexUtil.fromHex((String)str);
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        return ColorHexUtil.fromHex((String)str, (Color)defaultValue);
    }

    public static boolean isDark(@NotNull Color c) {
        return (ColorUtil.getLuminance(c) + 0.05) / 0.05 < 4.5;
    }

    public static boolean areContrasting(@NotNull Color c1, @NotNull Color c2) {
        return Double.compare(ColorUtil.getContrast(c1, c2), 4.5) >= 0;
    }

    public static double getContrast(@NotNull Color c1, @NotNull Color c2) {
        double l1 = ColorUtil.getLuminance(c1);
        double l2 = ColorUtil.getLuminance(c2);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l2, l1) + 0.05);
    }

    public static double getLuminance(@NotNull Color color) {
        return ColorUtil.getLinearRGBComponentValue((double)color.getRed() / 255.0) * 0.2126 + ColorUtil.getLinearRGBComponentValue((double)color.getGreen() / 255.0) * 0.7152 + ColorUtil.getLinearRGBComponentValue((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double getLinearRGBComponentValue(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        if (balance <= 0.0) {
            return c1;
        }
        if (balance >= 1.0) {
            return c2;
        }
        MixedColorProducer func = new MixedColorProducer(c1, c2, balance);
        return c1 instanceof JBColor || c2 instanceof JBColor ? new JBColor(func) : (Color)func.produce();
    }
}

