/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ActiveComponent;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptionPanel
extends JPanel {
    public static final Color CNT_ACTIVE_COLOR = new JBColor(Gray._202, Gray._55);
    public static final Color CNT_ACTIVE_BORDER_COLOR = new JBColor((NotNullProducer<? extends Color>)((NotNullProducer)() -> StartupUiUtil.isUnderDarcula() ? JBColor.border() : CNT_ACTIVE_COLOR));
    private boolean myActive = false;
    private ActiveComponent myButtonComponent;
    private JComponent mySettingComponent;

    public CaptionPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.isBackgroundSet() ? this.getBackground() : JBUI.CurrentTheme.Popup.headerBackground(this.myActive));
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setActive(boolean active) {
        this.myActive = active;
        if (this.myButtonComponent != null) {
            this.myButtonComponent.setActive(active);
        }
        this.repaint();
    }

    public void setButtonComponent(@NotNull ActiveComponent component, @Nullable Border border) {
        if (this.myButtonComponent != null) {
            this.remove(this.myButtonComponent.getComponent());
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(border);
        panel.add((Component)new JLabel(" "), "West");
        panel.add((Component)component.getComponent(), "Center");
        panel.setOpaque(false);
        this.add((Component)panel, "East");
        this.myButtonComponent = component;
    }

    public void addSettingsComponent(Component component) {
        if (this.mySettingComponent == null) {
            this.mySettingComponent = new JPanel();
            this.mySettingComponent.setOpaque(false);
            this.mySettingComponent.setLayout(new BoxLayout(this.mySettingComponent, 0));
            this.add((Component)this.mySettingComponent, "West");
        }
        this.mySettingComponent.add(component);
    }

    public boolean isWithinPanel(MouseEvent e) {
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), this);
        Component c = this.findComponentAt(p);
        return c != null && c != this.myButtonComponent;
    }

    protected boolean containsSettingsControls() {
        return this.mySettingComponent != null || this.myButtonComponent != null;
    }
}

