/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project.dependencies;

import com.intellij.openapi.externalSystem.model.project.dependencies.AbstractDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.serialization.PropertyMapping;
import org.jetbrains.annotations.NotNull;

public class ArtifactDependencyNodeImpl
extends AbstractDependencyNode
implements ArtifactDependencyNode {
    private final String group;
    private final String module;
    private final String version;

    @PropertyMapping(value={"id", "group", "module", "version"})
    public ArtifactDependencyNodeImpl(long id, @NotNull String group, @NotNull String module, @NotNull String version) {
        super(id);
        this.group = group;
        this.module = module;
        this.version = version;
    }

    @Override
    @NotNull
    public String getGroup() {
        return this.group;
    }

    @Override
    @NotNull
    public String getModule() {
        return this.module;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.group + ':' + this.module + ':' + this.version;
    }

    @Override
    public boolean match(AbstractDependencyNode dependencyNode) {
        if (dependencyNode == null || this.getClass() != dependencyNode.getClass()) {
            return false;
        }
        ArtifactDependencyNodeImpl node = (ArtifactDependencyNodeImpl)dependencyNode;
        if (!this.group.equals(node.group)) {
            return false;
        }
        if (!this.module.equals(node.module)) {
            return false;
        }
        return this.version.equals(node.version);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

