/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.PlatformVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getBuildSystemType", "", "it", "Lcom/intellij/openapi/module/Module;", "getGroupId", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getPlatform", "getVersion", "", "kotlin.core"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (PlatformVersion.Companion.isAndroidStudio()) {
            return SetsKt.emptySet();
        }
        boolean bl = false;
        Set metrics = new LinkedHashSet();
        List list = ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ProjectFacetManager.getI\u2026(KotlinFacetType.TYPE_ID)");
        List modulesWithFacet = list;
        Collection collection = modulesWithFacet;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            String pluginVersion = KotlinPluginUtil.getPluginVersion();
            Iterable $this$forEach$iv = modulesWithFacet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl3 = false;
                Module module = it;
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"it");
                String buildSystem = this.getBuildSystemType(module);
                String platform = this.getPlatform(it);
                String languageVersion = PlatformKt.getLanguageVersionSettings(it).getLanguageVersion().getVersionString();
                FeatureUsageData data = new FeatureUsageData().addData("pluginVersion", pluginVersion).addData("system", buildSystem).addData("platform", platform).addData("languageVersion", languageVersion);
                MetricEvent usageDescriptor = new MetricEvent("Build", data);
                metrics.add(usageDescriptor);
            }
        }
        return metrics;
    }

    private final String getPlatform(Module it) {
        return JvmPlatformKt.isJvm((TargetPlatform)PlatformKt.getPlatform(it)) ? "jvm" : (JsPlatformKt.isJs((TargetPlatform)PlatformKt.getPlatform(it)) ? "js" : (TargetPlatformKt.isCommon((TargetPlatform)PlatformKt.getPlatform(it)) ? "common" : (NativePlatformKt.isNative((TargetPlatform)PlatformKt.getPlatform(it)) ? "native" : "unknown")));
    }

    private final String getBuildSystemType(Module it) {
        String string;
        BuildSystemType buildSystem = BuildSystemTypeKt.getBuildSystemType(it);
        if (Intrinsics.areEqual((Object)buildSystem, (Object)BuildSystemType.JPS.INSTANCE)) {
            string = "JPS";
        } else {
            String string2 = buildSystem.toString();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string = "Maven";
            } else {
                string2 = buildSystem.toString();
                bl = false;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                string = StringsKt.contains$default((CharSequence)string6, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string;
    }

    @NotNull
    public String getGroupId() {
        return "kotlin.project.configuration";
    }

    public int getVersion() {
        return 1;
    }
}

